/*
 * Decompiled with CFR 0.152.
 */
package ff;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kutil.core.Int2D;
import kutil.core.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ob {
    private Type type;
    private List<Int2D> shape;
    private Sigs[] signifs;
    private Int2D pos1;
    private Int2D pos2;
    private char px;

    public static void main(String[] args) {
        Log.it("Hello world!");
        String[] seaStrs = new String[]{"      ", " a a  ", " aaa  ", "   a  "};
        Ob ob = new Ob('a', seaStrs);
    }

    public Ob(char pix, Set<Int2D> poses) {
        this.px = pix;
        this.type = Ob.typeByPx(pix);
        this.shapeAndPosFromPoses(poses);
        this.signifs = this.mkSignifs(this.shape);
    }

    public Ob(char pix, String[] seaStrs) {
        this.px = pix;
        this.type = Ob.typeByPx(pix);
        this.shapeAndPosFromStrs(seaStrs);
        this.signifs = this.mkSignifs(this.shape);
    }

    public void removePx(Int2D pos) {
        this.shape.remove(pos.minus(this.pos1));
        if (this.shape.contains(pos)) {
            throw new Error("nEEEEE");
        }
        this.signifs = this.mkSignifs(this.shape);
    }

    public void insertPx(Int2D pos) {
        LinkedList<Int2D> newShape;
        Int2D delta;
        this.shape.add(pos.minus(this.pos1));
        int x = pos.getX();
        int y = pos.getY();
        if (x > this.pos2.getX()) {
            this.pos2 = new Int2D(x, this.pos2.getY());
        }
        if (y > this.pos2.getY()) {
            this.pos2 = new Int2D(this.pos2.getX(), y);
        }
        if (x < this.pos1.getX()) {
            delta = new Int2D(this.pos1.getX() - x, 0);
            this.pos1 = new Int2D(x, this.pos1.getY());
            newShape = new LinkedList<Int2D>();
            for (Int2D p : this.shape) {
                newShape.add(p.plus(delta));
            }
            this.shape = newShape;
        }
        if (y < this.pos1.getY()) {
            delta = new Int2D(0, this.pos1.getY() - y);
            this.pos1 = new Int2D(this.pos1.getX(), y);
            newShape = new LinkedList();
            for (Int2D p : this.shape) {
                newShape.add(p.plus(delta));
            }
            this.shape = newShape;
        }
        this.signifs = this.mkSignifs(this.shape);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Ob) {
            Ob ob = (Ob)obj;
            return ob.px == this.px;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + this.px;
        return hash;
    }

    public void move(Dir dir) {
        Int2D delta = Ob.dirDelta(dir);
        this.pos1 = this.pos1.plus(delta);
        this.pos2 = this.pos2.plus(delta);
    }

    public List<Int2D> getPoses() {
        LinkedList<Int2D> ret = new LinkedList<Int2D>();
        for (Int2D p : this.shape) {
            ret.add(p.plus(this.pos1));
        }
        return ret;
    }

    public List<Int2D> getSigPoses(Dir dir) {
        LinkedList<Int2D> ret = new LinkedList<Int2D>();
        for (Int2D pos : this.signifs[dir.i()].sigs) {
            ret.add(pos.plus(this.pos1));
        }
        return ret;
    }

    public Type getType() {
        return this.type;
    }

    public char getPx() {
        if (this.isDead()) {
            return '+';
        }
        return this.px;
    }

    public void kill() {
        if (this.isFish()) {
            this.type = Type.DEAD_FISH;
        }
    }

    public boolean isWall() {
        return this.type == Type.WALL;
    }

    public boolean isStd() {
        return this.type == Type.STD;
    }

    public boolean isSteel() {
        return this.type == Type.STEEL;
    }

    public boolean isBlock() {
        return this.isStd() || this.isSteel();
    }

    public boolean isFish() {
        return this.type == Type.BIG_FISH || this.type == Type.SMALL_FISH || this.type == Type.DEAD_FISH;
    }

    public boolean isDead() {
        return this.type == Type.DEAD_FISH;
    }

    public boolean isBigFish() {
        return this.type == Type.BIG_FISH;
    }

    public boolean isSmallFish() {
        return this.type == Type.SMALL_FISH;
    }

    private Sigs[] mkSignifs(List<Int2D> sh) {
        Sigs[] signifs_ = new Sigs[]{this.mkSigs(Dir.UP, sh), this.mkSigs(Dir.DOWN, sh), this.mkSigs(Dir.LEFT, sh), this.mkSigs(Dir.RIGHT, sh)};
        return signifs_;
    }

    private static int relevantPart(Dir dir, Int2D p) {
        switch (dir) {
            case UP: 
            case DOWN: {
                return p.getY();
            }
        }
        return p.getX();
    }

    private Sigs mkSigs(Dir dir, List<Int2D> sh) {
        LinkedList<Int2D> ret = new LinkedList<Int2D>();
        List<List<Int2D>> layers = this.sepLayers(dir, sh);
        List<Int2D> last = layers.get(0);
        for (Int2D p : last) {
            ret.add(p.plus(Ob.dirDelta(dir)));
        }
        for (int i = 1; i < layers.size(); ++i) {
            LinkedList<Int2D> adds = new LinkedList<Int2D>();
            for (Int2D p : layers.get(i)) {
                Int2D checkFor = p.plus(Ob.dirDelta(dir));
                if (last.contains(checkFor)) continue;
                adds.add(checkFor);
            }
            ret.addAll(adds);
            last = layers.get(i);
        }
        return new Sigs(ret);
    }

    private List<List<Int2D>> sepLayers(Dir dir, List<Int2D> lst) {
        int i1 = Ob.relevantPart(dir, this.pos1);
        int i2 = Ob.relevantPart(dir, this.pos2);
        int size = i2 - i1 + 1;
        ArrayList<List<Int2D>> ret = new ArrayList<List<Int2D>>(size);
        for (int k = 0; k < size; ++k) {
            ret.add(k, new LinkedList());
        }
        for (Int2D p : lst) {
            int i = Ob.relevantPart(dir, p);
            if (dir == Dir.DOWN || dir == Dir.RIGHT) {
                i = size - i - 1;
            }
            ((List)ret.get(i)).add(p);
        }
        return ret;
    }

    public static Dir rot180(Dir dir) {
        switch (dir) {
            case UP: {
                return Dir.DOWN;
            }
            case DOWN: {
                return Dir.UP;
            }
            case LEFT: {
                return Dir.RIGHT;
            }
        }
        return Dir.LEFT;
    }

    public static Int2D dirDelta(Dir dir) {
        switch (dir) {
            case UP: {
                return new Int2D(0, -1);
            }
            case DOWN: {
                return new Int2D(0, 1);
            }
            case LEFT: {
                return new Int2D(-1, 0);
            }
        }
        return new Int2D(1, 0);
    }

    private void shapeAndPosFromPoses(Set<Int2D> poses) {
        this.shape = new LinkedList<Int2D>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (Int2D pos : poses) {
            int x = pos.getX();
            int y = pos.getY();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            this.shape.add(pos);
        }
        for (Int2D p : this.shape) {
            p.adjustX(-minX);
            p.adjustY(-minY);
        }
        this.pos1 = new Int2D(minX, minY);
        this.pos2 = new Int2D(maxX, maxY);
    }

    private void shapeAndPosFromStrs(String[] seaStrs) {
        this.shape = new LinkedList<Int2D>();
        int numRows = seaStrs.length;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < seaStrs[i].length(); ++j) {
                char ch = seaStrs[i].charAt(j);
                if (ch != this.px) continue;
                int x = j;
                int y = i;
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y > maxY) {
                    maxY = y;
                }
                this.shape.add(new Int2D(x, y));
            }
        }
        for (Int2D p : this.shape) {
            p.adjustX(-minX);
            p.adjustY(-minY);
        }
        this.pos1 = new Int2D(minX, minY);
        this.pos2 = new Int2D(maxX, maxY);
    }

    public static Type typeByPx(char px) {
        switch (px) {
            case '$': {
                return Type.WALL;
            }
            case '~': {
                return Type.SMALL_FISH;
            }
            case '#': {
                return Type.BIG_FISH;
            }
            case '+': {
                return Type.DEAD_FISH;
            }
        }
        if (Character.isUpperCase(px)) {
            return Type.STEEL;
        }
        return Type.STD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Sigs {
        public List<Int2D> sigs;

        public Sigs(List<Int2D> sigs_) {
            this.sigs = sigs_;
        }

        public String toString() {
            return this.sigs.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Dir {
        UP(0),
        DOWN(1),
        LEFT(2),
        RIGHT(3);

        private final int i;

        private Dir(int i_) {
            this.i = i_;
        }

        public int i() {
            return this.i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STD,
        STEEL,
        WALL,
        SMALL_FISH,
        BIG_FISH,
        DEAD_FISH;

    }
}

