/*
 * Decompiled with CFR 0.152.
 */
package ff;

import ff.MotionCmd;
import ff.MotionCommander;
import ff.Ob;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.core.Log;
import kutil.kobjects.Direction;
import kutil.kobjects.KObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sea
implements MotionCommander {
    Map<Int2D, Ob> posMap;
    Set<Ob> obSet;
    Set<Ob> moving;
    Int2D rec;
    LinkedList<Ob> fishes;
    GameStatus status;
    LinkedList<Cmd> waitingCmds;

    public static void main(String[] args) {
        Log.it("Hello world!");
        String[] seaStrs = new String[]{"               I             ", "             $$I$$           ", "              $I$            ", "              $I$            ", "              $I$     $$   $$", "$$$$$     $$$$$I$   $$$$$$$$$", "$$$$$$$$$$$$$$$I$$$$$$$$$$$$$", "$$$$$$$$$$$$$$$I$$$$$$$$$$$$$", "$$$$$$$$$$$     $$$$$$$$$$$$$", "$$$$$$$           $$$$$$$$$$$", "$$$$                 $$$$$$$$", "$$$                    $$$$$$", "$$$                    $$$$$$", "$$$                     $$$$$", "$$$                      $$$$", "$$$                        $$", "$$$                          ", "$$$    a~~~        ####c     ", "$$$    addd bbbbbbb####c     ", "$$$$   aaaa  b   b  cccc     ", "$$$$$  a  a  b   b  c  c  $$$", "$$$$$$$a  a  b   b  c  c $$$$", "$$$$$$$$$$$$$$$$$$$$$$$$$$$$$", "$$$$$$$$$$$$$$$$$$$$$$$$$$$$$", "$$$$$$$$$$$$$$$$$$$$$$$$$$$$$", "$$$$$$$$$$$$$$$$$$$$$$$$$$$$$", "$$$$$$$$$$$$$$$$$$$$$$$$$$$$$"};
        Sea sea = new Sea(seaStrs);
        sea.fallSteps_();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            block2: while (true) {
                System.out.print("$ ");
                String str = in.readLine();
                if (!str.equals("")) {
                    char[] arr$ = str.toCharArray();
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) continue block2;
                        char ch = arr$[i$];
                        sea.fishStep_(ch);
                        ++i$;
                    }
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fishStep_(char ch) {
        this.fishStep(Sea.toCmd(ch));
        this.fallSteps_();
    }

    private void fallSteps_() {
        while (this.isMoving()) {
            Log.it(this);
            this.fallStep();
        }
        Log.it(this);
    }

    @Override
    public void cmd(KObject o) {
        if (o instanceof Direction) {
            Direction dire = (Direction)o;
            Cmd cmd = null;
            switch (dire.get()) {
                case up: {
                    cmd = Cmd.U;
                    break;
                }
                case down: {
                    cmd = Cmd.D;
                    break;
                }
                case left: {
                    cmd = Cmd.L;
                    break;
                }
                case right: {
                    cmd = Cmd.R;
                    break;
                }
                case randdir: {
                    cmd = Cmd.values()[Global.random().nextInt(4)];
                }
            }
            this.waitingCmds.add(cmd);
        }
    }

    @Override
    public List<MotionCmd> getNewCmds() {
        if (this.isMoving()) {
            return this.fallStep();
        }
        if (!this.waitingCmds.isEmpty()) {
            return this.fishStep(this.waitingCmds.pop());
        }
        return new LinkedList<MotionCmd>();
    }

    @Override
    public void addBlock(char px, Set<Int2D> poses) {
        if ('$' == px) {
            for (Ob ob : this.obSet) {
                if (ob.getPx() != '$') continue;
                for (Int2D pos : poses) {
                    ob.insertPx(pos);
                    this.posMap.put(pos, ob);
                }
                this.moving = this.mkMoving();
                return;
            }
        }
        Ob ob = new Ob(px, poses);
        this.obSet.add(ob);
        for (Int2D pos : ob.getPoses()) {
            this.posMap.put(pos, ob);
        }
        if (ob.isFish()) {
            this.fishes.addFirst(ob);
            if (ob.isDead()) {
                this.status = GameStatus.GameOver;
            }
        }
        this.moving = this.mkMoving();
    }

    @Override
    public void removeBlock2(Set<Int2D> poses) {
        for (Int2D pos : poses) {
            Ob ob = this.posMap.get(pos);
            Log.it("rm2: " + pos);
            if (ob == null) {
                Log.it("ERROR !!!! :  v removeBlock2 je chyba ze v poses je elemnt rovnej null");
                return;
            }
            if (ob.getPx() == '$') {
                Log.it("DELETUJU $!");
                ob.removePx(pos);
                this.posMap.remove(pos);
                continue;
            }
            throw new Error("Tohle se m\u00e1 pou\u017e\u00edvat jen na $");
        }
        this.moving = this.mkMoving();
    }

    @Override
    public void removeBlock(char px) {
        for (Ob ob : this.obSet) {
            if (ob.getPx() != px) continue;
            this.removeOb(ob);
            break;
        }
        this.moving = this.mkMoving();
    }

    public Sea(Int2D rectangle) {
        this.rec = rectangle;
        this.init();
        this.moving = new HashSet<Ob>();
    }

    private void init() {
        this.obSet = new HashSet<Ob>();
        this.posMap = new HashMap<Int2D, Ob>();
        this.fishes = new LinkedList();
        this.status = GameStatus.Normal;
        this.waitingCmds = new LinkedList();
    }

    public Sea(String[] seaStrs) {
        this.rec = Sea.recFromStrs(seaStrs);
        this.init();
        for (char ch : Sea.charsIn(seaStrs)) {
            Ob ob = new Ob(ch, seaStrs);
            this.obSet.add(ob);
            for (Int2D pos : ob.getPoses()) {
                this.posMap.put(pos, ob);
            }
            if (!ob.isFish()) continue;
            this.fishes.addFirst(ob);
            if (!ob.isDead()) continue;
            this.status = GameStatus.GameOver;
        }
        this.moving = this.mkMoving();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int rows = this.rec.getY();
        int cols = this.rec.getX();
        if (this.status == GameStatus.YouWin) {
            sb.append("Y O U   W I N   !!!");
        }
        if (this.status == GameStatus.GameOver) {
            sb.append("G A M E   O V E R   !!!");
        }
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Ob ob = this.posMap.get(new Int2D(j, i));
                char px = ob == null ? (char)' ' : (char)ob.getPx();
                sb.append(px);
                sb.append(' ');
            }
            sb.append('\n');
        }
        sb.append("Moving : ");
        for (Ob o : this.moving) {
            sb.append(o.getPx());
            sb.append(' ');
        }
        sb.append("\nActual fish : ");
        if (!this.fishes.isEmpty()) {
            sb.append(this.fishes.getFirst().getPx());
        }
        return sb.toString();
    }

    private Set<Ob> mkMoving() {
        HashSet<Ob> wallsAndFishes = new HashSet<Ob>();
        HashSet<Ob> ret = new HashSet<Ob>();
        for (Ob o : this.obSet) {
            ret.add(o);
            if (!o.isFish() && !o.isWall()) continue;
            wallsAndFishes.add(o);
        }
        HashSet<Ob> fixeds = new HashSet<Ob>();
        for (Ob wof : wallsAndFishes) {
            fixeds.addAll(this.haDeNeighbors(Ob.Dir.UP, wof));
        }
        ret.removeAll(fixeds);
        return ret;
    }

    public boolean isMoving() {
        return !this.moving.isEmpty();
    }

    public List<MotionCmd> fishStep(Cmd cmd) {
        Ob actFish;
        Set<Ob> pusheds;
        LinkedList<MotionCmd> ret = new LinkedList<MotionCmd>();
        if (cmd == null) {
            return ret;
        }
        Ob.Dir dir = Sea.toDir(cmd);
        if (dir == null) {
            Ob firstFish = this.fishes.removeFirst();
            this.fishes.addLast(firstFish);
        } else if (!this.fishes.isEmpty() && (pusheds = this.getMoveables(dir, actFish = this.fishes.getFirst())) != null) {
            for (Ob o : pusheds) {
                this.move(dir, o);
                ret.add(new MotionCmd(o.getPx(), Ob.dirDelta(dir)));
            }
            this.moving = this.mkMoving();
            if (dir == Ob.Dir.LEFT || dir == Ob.Dir.RIGHT) {
                for (Ob fish : this.fishes) {
                    if (!this.isSpineKilled(pusheds, fish) && !this.isSteelKilled(fish)) continue;
                    fish.kill();
                    this.status = GameStatus.GameOver;
                }
            }
            if (this.status == GameStatus.Normal && this.isGoal(actFish)) {
                this.removeOb(actFish);
                this.fishes.removeFirst();
                if (this.fishes.isEmpty()) {
                    this.status = GameStatus.YouWin;
                }
                this.moving = this.mkMoving();
            }
        }
        return ret;
    }

    private void removeOb(Ob ob) {
        for (Int2D pos : ob.getPoses()) {
            this.posMap.remove(pos);
        }
        this.obSet.remove(ob);
    }

    private boolean isGoal(Ob fish) {
        for (Int2D fishPos : fish.getPoses()) {
            int x = fishPos.getX();
            int y = fishPos.getY();
            if (x > 0 && y > 0 && x < this.rec.getX() - 1 && y < this.rec.getY() - 1) continue;
            return true;
        }
        return false;
    }

    private boolean isSpineKilled(Set<Ob> pusheds, Ob fish) {
        for (Ob o : this.neighbors(Ob.Dir.UP, fish)) {
            if (!o.isBlock() || !pusheds.contains(o) || this.isFixedByWall(o)) continue;
            return true;
        }
        return false;
    }

    private boolean isSteelKilled(Ob fish) {
        if (fish.isBigFish()) {
            return false;
        }
        for (Ob o : this.haDeNeighbors(Ob.Dir.UP, fish)) {
            if (!o.isSteel() || this.isFixedByWall(o)) continue;
            return true;
        }
        return false;
    }

    private boolean isFixedByWall(Ob ob) {
        for (Ob o : this.haDeNeighbors(Ob.Dir.DOWN, ob)) {
            if (!o.isWall()) continue;
            return true;
        }
        return false;
    }

    private Set<Ob> getMoveables(Ob.Dir dir, Ob fish) {
        Set<Ob> xs = this.haDeNeighbors(dir, fish);
        for (Ob o : xs) {
            if (o.isWall()) {
                return null;
            }
            if (o.isFish() && !o.equals(fish)) {
                return null;
            }
            if (!o.isSteel() || !o.isSmallFish()) continue;
            return null;
        }
        return xs;
    }

    public static Ob.Dir toDir(Cmd cmd) {
        switch (cmd) {
            case U: {
                return Ob.Dir.UP;
            }
            case D: {
                return Ob.Dir.DOWN;
            }
            case L: {
                return Ob.Dir.LEFT;
            }
            case R: {
                return Ob.Dir.RIGHT;
            }
        }
        return null;
    }

    public static Cmd toCmd(char ch) {
        switch (ch) {
            case 'w': {
                return Cmd.U;
            }
            case 's': {
                return Cmd.D;
            }
            case 'a': {
                return Cmd.L;
            }
            case 'd': {
                return Cmd.R;
            }
            case ' ': {
                return Cmd.S;
            }
        }
        return null;
    }

    public List<MotionCmd> fallStep() {
        LinkedList<MotionCmd> ret = new LinkedList<MotionCmd>();
        if (!this.isMoving()) {
            return ret;
        }
        Ob.Dir down = Ob.Dir.DOWN;
        for (Ob ob : this.moving) {
            this.move(down, ob);
            ret.add(new MotionCmd(ob.getPx(), Ob.dirDelta(down)));
        }
        Set<Ob> stoppeds = this.updateMoving();
        Set<Ob> killedFishes = this.getKilledFishes(stoppeds);
        if (!killedFishes.isEmpty()) {
            this.status = GameStatus.GameOver;
        }
        for (Ob fish : killedFishes) {
            fish.kill();
        }
        return ret;
    }

    private Set<Ob> getKilledFishes(Set<Ob> stoppeds) {
        HashSet<Ob> ret = new HashSet<Ob>();
        for (Ob stopped : stoppeds) {
            Set<Ob> obs = this.haDeNeighbors(Ob.Dir.DOWN, stopped);
            if (!Sea.separateWalls(obs).isEmpty()) continue;
            ret.addAll(Sea.separateFishes(obs));
        }
        return ret;
    }

    private static Set<Ob> separateFishes(Set<Ob> obs) {
        HashSet<Ob> ret = new HashSet<Ob>();
        for (Ob ob : obs) {
            if (!ob.isFish()) continue;
            ret.add(ob);
        }
        return ret;
    }

    private static Set<Ob> separateWalls(Set<Ob> obs) {
        HashSet<Ob> ret = new HashSet<Ob>();
        for (Ob ob : obs) {
            if (!ob.isWall()) continue;
            ret.add(ob);
        }
        return ret;
    }

    private static Set<Ob> separateStdOrSteel(Set<Ob> obs) {
        HashSet<Ob> ret = new HashSet<Ob>();
        for (Ob ob : obs) {
            if (!ob.isStd() && !ob.isSteel()) continue;
            ret.add(ob);
        }
        return ret;
    }

    private Set<Ob> updateMoving() {
        boolean hotovo;
        HashSet<Ob> stoppeds = new HashSet<Ob>();
        do {
            hotovo = true;
            HashSet<Ob> toRemove = new HashSet<Ob>();
            for (Ob mov : this.moving) {
                if (!this.isFixedNow(mov, this.moving)) continue;
                hotovo = false;
                toRemove.add(mov);
                stoppeds.add(mov);
            }
            this.moving.removeAll(toRemove);
        } while (!hotovo);
        return stoppeds;
    }

    private boolean isFixedNow(Ob ob, Set<Ob> movs) {
        for (Ob neib : this.neighbors(Ob.Dir.DOWN, ob)) {
            if (movs.contains(neib)) continue;
            return true;
        }
        return false;
    }

    private void move(Ob.Dir dir, Ob ob) {
        List<Int2D> posesToInsert = ob.getSigPoses(dir);
        ob.move(dir);
        List<Int2D> posesToDelete = ob.getSigPoses(Ob.rot180(dir));
        for (Int2D posToDel : posesToDelete) {
            Ob there = this.posMap.get(posToDel);
            if (there == null || !ob.equals(there)) continue;
            this.posMap.remove(posToDel);
        }
        for (Int2D posToIns : posesToInsert) {
            this.posMap.put(posToIns, ob);
        }
    }

    private Set<Ob> haDeNeighbors(Ob.Dir dir, Ob ob) {
        HashSet<Ob> acc = new HashSet<Ob>();
        Stack<Ob> stack = new Stack<Ob>();
        stack.push(ob);
        boolean firstLoop = true;
        while (!stack.empty()) {
            Ob top = (Ob)stack.pop();
            Set<Object> childs = (top.isFish() || top.isWall()) && !firstLoop ? new HashSet() : this.neighbors(dir, top);
            childs.removeAll(acc);
            for (Ob ob2 : childs) {
                stack.add(ob2);
            }
            acc.add(top);
            firstLoop = false;
        }
        return acc;
    }

    private Set<Ob> neighbors(Ob.Dir dir, Ob ob) {
        HashSet<Ob> ret = new HashSet<Ob>();
        List<Int2D> sigs = ob.getSigPoses(dir);
        for (Int2D pos : sigs) {
            Ob neigbor = this.posMap.get(pos);
            if (neigbor == null) continue;
            ret.add(neigbor);
        }
        return ret;
    }

    private static Int2D recFromStrs(String[] strs) {
        int maxLen = Integer.MIN_VALUE;
        for (String str : strs) {
            int len = str.length();
            if (len <= maxLen) continue;
            maxLen = len;
        }
        return new Int2D(maxLen, strs.length);
    }

    private static List<Character> charsIn(String[] strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str);
        }
        HashSet<Character> charSet = new HashSet<Character>();
        for (char ch : sb.toString().toCharArray()) {
            charSet.add(Character.valueOf(ch));
        }
        charSet.remove(Character.valueOf(' '));
        LinkedList<Character> ret = new LinkedList<Character>();
        Iterator i$ = charSet.iterator();
        while (i$.hasNext()) {
            char ch = ((Character)i$.next()).charValue();
            ret.add(Character.valueOf(ch));
        }
        Collections.sort(ret);
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NResult {
        private Set<Ob> stds;
        private Set<Ob> steels;
        private Set<Ob> walls;
        private Set<Ob> fishes;
        private Set<Ob> all;

        public Set<Ob> getFishes() {
            return this.fishes;
        }

        public Set<Ob> getWalls() {
            return this.walls;
        }

        private void init() {
            this.stds = new HashSet<Ob>();
            this.steels = new HashSet<Ob>();
            this.walls = new HashSet<Ob>();
            this.fishes = new HashSet<Ob>();
            this.all = new HashSet<Ob>();
        }

        public NResult() {
            this.init();
        }

        public NResult(Set<Ob> obs) {
            this.init();
            for (Ob ob : obs) {
                this.add(ob);
            }
        }

        public final void add(Ob ob) {
            this.all.add(ob);
            switch (ob.getType()) {
                case BIG_FISH: 
                case SMALL_FISH: 
                case DEAD_FISH: {
                    this.fishes.add(ob);
                    break;
                }
                case STD: {
                    this.stds.add(ob);
                    break;
                }
                case STEEL: {
                    this.steels.add(ob);
                    break;
                }
                case WALL: {
                    this.walls.add(ob);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cmd {
        U,
        D,
        L,
        R,
        S;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameStatus {
        Normal,
        GameOver,
        YouWin;

    }
}

