/*
 * Decompiled with CFR 0.152.
 */
package kutil.core;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kutil.core.Global;
import kutil.core.Int2D;

public class Console
extends JPanel
implements ActionListener,
WindowListener {
    protected JTextField textField;
    protected JTextArea textArea;
    private static final String newline = "\n";
    private JFrame frame;
    private Int2D loc;
    private static final Font font = new Font("Monospaced", 0, 12);

    public Console(Int2D loc) {
        super(new GridBagLayout());
        this.loc = loc;
        this.textField = new JTextField(32);
        this.textField.setFont(font);
        this.textField.addActionListener(this);
        this.textArea = new JTextArea(25, 32);
        this.textArea.setEditable(false);
        this.textArea.setFont(font);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)this.textField, c);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)scrollPane, c);
        this.createAndShowGUI();
    }

    public void actionPerformed(ActionEvent evt) {
        String text = this.textField.getText();
        this.textArea.append(" >    " + text + newline);
        this.textField.selectAll();
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        Global.rucksack().handleConsoleCmd(this, text);
    }

    public void printString(String str) {
        this.textArea.append(" #    " + str + newline);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    private void createAndShowGUI() {
        this.frame = new JFrame("Console");
        this.frame.setLocation(this.loc.getX(), this.loc.getY());
        this.frame.setAlwaysOnTop(true);
        this.frame.addWindowListener(this);
        this.frame.add(this);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void requestFocus() {
        super.requestFocus();
        this.textField.requestFocus();
    }

    public void setCmd(String str) {
        this.textField.setText(str);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        Global.rucksack().closeConsole();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public JFrame getJFrame() {
        return this.frame;
    }
}

