/*
 * Decompiled with CFR 0.152.
 */
package kutil.core;

import java.awt.event.MouseEvent;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;

public class Int2D {
    private int x;
    private int y;
    public static final Int2D zero = new Int2D(0, 0);

    public Int2D(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Int2D align(int gridSide) {
        int newX = gridSide * Math.round((float)this.x / (float)gridSide);
        int neyY = gridSide * Math.round((float)this.y / (float)gridSide);
        return new Int2D(newX, neyY);
    }

    public boolean equals(Object o) {
        if (o instanceof Int2D) {
            Int2D pos = (Int2D)o;
            return pos.x == this.x && pos.y == this.y;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + this.x;
        hash = 59 * hash + this.y;
        return hash;
    }

    public Int2D(Int2D i) {
        this.x = i.x;
        this.y = i.y;
    }

    public Int2D copy() {
        return new Int2D(this.x, this.y);
    }

    public static Int2D zero() {
        return new Int2D(0, 0);
    }

    public static Int2D parseInt2D(String str) {
        String[] arr = str.trim().split("\\s+", 2);
        if (arr.length != 2) {
            return new Int2D(0, 0);
        }
        return new Int2D(Integer.parseInt(arr[0]), Integer.parseInt(arr[1]));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public double abs() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void setX(int newX) {
        this.x = newX;
    }

    public void setY(int newY) {
        this.y = newY;
    }

    public void set(ROVector2f bodyPos) {
        this.x = (int)bodyPos.getX();
        this.y = (int)bodyPos.getY();
    }

    public void adjustX(int dx) {
        this.x += dx;
    }

    public void adjustY(int dy) {
        this.y += dy;
    }

    public Int2D times(double q) {
        Int2D ret = new Int2D(this.x, this.y);
        ret.x = (int)Math.round(q * (double)this.x);
        ret.y = (int)Math.round(q * (double)this.y);
        return ret;
    }

    public Int2D plus(Int2D i) {
        Int2D ret = new Int2D(this.x, this.y);
        ret.x += i.x;
        ret.y += i.y;
        return ret;
    }

    public Int2D minus(Int2D i) {
        Int2D ret = new Int2D(this.x, this.y);
        ret.x -= i.x;
        ret.y -= i.y;
        return ret;
    }

    public Int2D negate() {
        return new Int2D(-this.x, -this.y);
    }

    public String toString() {
        return this.x + " " + this.y;
    }

    public static boolean rectangeHit(Int2D clickPos, Int2D cornerPos, int width, int height) {
        if (clickPos.getX() < cornerPos.getX()) {
            return false;
        }
        if (clickPos.getY() < cornerPos.getY()) {
            return false;
        }
        if (clickPos.getX() > cornerPos.getX() + width) {
            return false;
        }
        return clickPos.getY() <= cornerPos.getY() + height;
    }

    public static boolean rectangeHit(MouseEvent e, Int2D pos, int width, int height) {
        if (e.getX() < pos.getX()) {
            return false;
        }
        if (e.getY() < pos.getY()) {
            return false;
        }
        if (e.getX() > pos.getX() + width) {
            return false;
        }
        return e.getY() <= pos.getY() + height;
    }

    public static ROVector2f[] toROVector2f(Int2D[] vs) {
        ROVector2f[] ret = new ROVector2f[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            ret[i] = new Vector2f(vs[i].getX(), vs[i].getY());
        }
        return ret;
    }

    public static Vector2f toROVector2f(Int2D int2D) {
        return new Vector2f(int2D.getX(), int2D.getY());
    }

    public static Int2D fromROVector2f(ROVector2f rov) {
        return new Int2D((int)rov.getX(), (int)rov.getY());
    }
}

