/*
 * Decompiled with CFR 0.152.
 */
package kutil.core;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import kutil.core.Console;
import kutil.core.Editor;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.core.Log;
import kutil.core.Scheduler;
import kutil.core.Utils;
import kutil.functions.ErroneousImplementation;
import kutil.functions.FakeImplementation;
import kutil.kobjects.Basic;
import kutil.kobjects.Figure;
import kutil.kobjects.Frame;
import kutil.kobjects.Function;
import kutil.kobjects.Inputable;
import kutil.kobjects.KObject;
import kutil.kobjects.KObjectFactory;
import kutil.kobjects.Outputable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rucksack
implements ActionListener {
    private Scheduler scheduler;
    private KObject selected = null;
    private Frame selectedFrame = null;
    private KObject inClipboard;
    private KObject onCursor = null;
    private Int2D onCursorClickPos;
    private boolean lastTimeCut;
    private boolean showInfo = false;
    private boolean isSimulationRunning = false;
    private boolean brushInsertMode = false;
    private Int2D onDragAbsPos;
    private Int2D onDragPos;
    private int mouseX;
    private int mouseY;
    private Outputable from;
    private int fromPort;
    private JFrame popupFrame = null;
    private Int2D rightClickLocation;
    private LinkedList<String> undoBuffer;
    private LinkedList<String> redoBuffer;
    private KObject main;
    private Console console = null;
    private JFileChooser fileChooser = new JFileChooser();
    private Figure actualFigure = null;
    private static final String[] keyNames = new String[]{"ENTER", "BACK_SPACE", "I", "DELETE", "P", "SPACE", "control Z", "control shift Z", "F2", "control R", "LEFT", "RIGHT", "UP", "DOWN", "B", "control LEFT", "control RIGHT", "control UP", "control DOWN", "shift LEFT", "shift RIGHT", "shift UP", "shift DOWN", "control shift LEFT", "control shift RIGHT", "control shift UP", "control shift DOWN"};
    private int figureIndex = 0;
    private static final String firstLine = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    public Rucksack() {
        try {
            File f = new File(new File(".").getCanonicalPath());
            this.fileChooser.setCurrentDirectory(f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.undoBuffer = new LinkedList();
        this.redoBuffer = new LinkedList();
        this.resetFrom();
    }

    public LinkedList<String> cmd(String cmd) {
        String[] cmds = cmd.split(";");
        LinkedList<String> ret = new LinkedList<String>();
        for (int i = 0; i < cmds.length; ++i) {
            ret.add(this.oneCmd(cmds[i]));
        }
        return ret;
    }

    private String oneCmd(String cmd) {
        String[] parts = (cmd = cmd.trim()).split("\\s+");
        String cmdName = parts[0];
        if ("sendTo".equals(cmdName)) {
            if (parts.length < 3) {
                return "U sendTo mus\u00ed b\u00fdt id a p\u0159\u00edkaz.";
            }
            KObject o = Global.idDB().get(parts[1]);
            if (o != null) {
                return o.cmd(cmd.split("\\s+", 3)[2]);
            }
            return parts[1] + " nen\u00ed platn\u00e9 id.";
        }
        if ("changeXML".equals(cmdName)) {
            if (parts.length != 3) {
                return "changeXML pot\u0159ebuje 2 argumenty.";
            }
            this.changeXML(parts[1], parts[2], true);
            return "XML zm\u011bn\u011bno.";
        }
        if ("play".equals(cmdName)) {
            this.togglePausePlay();
            return "P\u0159epnuto.";
        }
        if ("changeInsertMode".equals(cmdName)) {
            this.changeInsertMode();
        }
        if ("showInfo".equals(cmdName)) {
            this.toggleShowInfo();
            return "P\u0159epnuto.";
        }
        if ("console".equals(cmdName)) {
            this.openConsole();
            return "Konzole otev\u0159ena.";
        }
        if ("undo".equals(cmdName)) {
            this.undo();
            return "Undone.";
        }
        if ("redo".equals(cmdName)) {
            this.redo();
            return "Redone.";
        }
        if ("rename".equals(cmdName)) {
            if (parts.length != 3) {
                return "rename pot\u0159ebuje 2 argumenty.";
            }
            return this.rename(parts[1], parts[2]) ? "Povedlo se p\u0159ejmenovat." : "Nepovedlo se p\u0159ejmenovat.";
        }
        if ("load".equals(cmdName)) {
            return this.load();
        }
        if ("save".equals(cmdName)) {
            return this.save();
        }
        if ("xml".equals(cmdName)) {
            if (parts.length < 2) {
                return "U xml mus\u00ed b\u00fdt argument (vkl\u00e1dan\u00e9 xml).";
            }
            String xml = cmd.split("\\s+", 2)[1];
            this.fromXmlToCursor(xml);
            return "XML (snad) vlo\u017eeno jako KObject.";
        }
        if ("bgcolor".equals(cmdName)) {
            if (parts.length < 3) {
                return "U bgcolor mus\u00ed b\u00fdt 2 argumenty: [id] [color r g b]";
            }
            String[] ps = cmd.split("\\s+", 3);
            return this.changeBgcolor(ps[1], ps[2]);
        }
        if ("selectedFrameTarger".equals(cmdName)) {
            if (parts.length < 2) {
                return "U selectedFrameTarger mus\u00ed b\u00fdt 1 argumenty: [id]";
            }
            return this.changeActualFrameTarget(parts[1]);
        }
        return "Neplatn\u00fd p\u0159\u00edkaz.";
    }

    public String[] getKeyNames() {
        return keyNames;
    }

    public void keyboardEvent(String str) {
        if ("ENTER".equals(str)) {
            this.enter();
        } else if ("BACK_SPACE".equals(str)) {
            this.backspace();
        } else if ("I".equals(str)) {
            this.toggleShowInfo();
        } else if ("DELETE".equals(str)) {
            this.delete();
        } else if ("P".equals(str)) {
            this.togglePausePlay();
        } else if ("SPACE".equals(str)) {
            this.openConsole();
        } else if ("F2".equals(str) || "control R".equals(str)) {
            this.renameDialog();
        } else if ("control Z".equals(str)) {
            this.undo();
        } else if ("control shift Z".equals(str)) {
            this.redo();
        } else if ("LEFT".equals(str)) {
            this.figureCmd(Figure.FigureCmd.left);
        } else if ("RIGHT".equals(str)) {
            this.figureCmd(Figure.FigureCmd.right);
        } else if ("UP".equals(str)) {
            this.figureCmd(Figure.FigureCmd.up);
        } else if ("DOWN".equals(str)) {
            this.figureCmd(Figure.FigureCmd.down);
        } else if ("control LEFT".equals(str)) {
            this.allFigureCmd(Figure.FigureCmd.left);
        } else if ("control RIGHT".equals(str)) {
            this.allFigureCmd(Figure.FigureCmd.right);
        } else if ("control UP".equals(str)) {
            this.allFigureCmd(Figure.FigureCmd.up);
        } else if ("control DOWN".equals(str)) {
            this.allFigureCmd(Figure.FigureCmd.down);
        } else if ("shift LEFT".equals(str)) {
            this.figureCmd(Figure.FigureCmd.shiftLeft);
        } else if ("shift RIGHT".equals(str)) {
            this.figureCmd(Figure.FigureCmd.shiftRight);
        } else if ("shift UP".equals(str)) {
            this.figureCmd(Figure.FigureCmd.shiftUp);
        } else if ("shift DOWN".equals(str)) {
            this.figureCmd(Figure.FigureCmd.shiftDown);
        } else if ("control shift LEFT".equals(str)) {
            this.allFigureCmd(Figure.FigureCmd.shiftLeft);
        } else if ("control shift RIGHT".equals(str)) {
            this.allFigureCmd(Figure.FigureCmd.shiftRight);
        } else if ("control shift UP".equals(str)) {
            this.allFigureCmd(Figure.FigureCmd.shiftUp);
        } else if ("control shift DOWN".equals(str)) {
            this.allFigureCmd(Figure.FigureCmd.shiftDown);
        } else if ("B".equals(str)) {
            this.changeFigure();
        } else {
            Log.it("ERR: neodchycena klavesa");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("copy".equals(cmd)) {
            this.inClipboard = this.selected;
        } else if ("undo".equals(cmd)) {
            this.undo();
        } else if ("paste to cursor".equals(cmd)) {
            this.copyToCursor(this.inClipboard);
        } else if ("copy to cursor".equals(cmd)) {
            this.copyToCursor(this.selected);
        } else if ("console".equals(cmd)) {
            this.openConsole();
        } else if ("show XML".equals(cmd)) {
            this.openEditor(this.selected.toXml().toString());
        } else if ("show Kisp".equals(cmd)) {
            this.openEditor(this.selected.toKisp());
        } else if ("add in and out".equals(cmd)) {
            ((Function)this.selected).addInAndOut();
        } else if ("glue bricks".equals(cmd)) {
            this.selected.getBasic().glueBricks();
        }
        if (this.popupFrame != null) {
            this.popupFrame.dispose();
        }
    }

    public void clickedRightMouseButton(Frame frame, int mouseX, int mouseY) {
        if (this.onCursor != null) {
            this.onCursor = null;
            return;
        }
        if (this.popupFrame != null) {
            this.popupFrame.dispose();
        }
        this.popupFrame = new JFrame("popup");
        this.popupFrame.setLocation(0, 0);
        this.popupFrame.setVisible(true);
        JPopupMenu popup = new JPopupMenu();
        if (this.selected instanceof Function) {
            this.addItemToPopup("add in and out", popup);
        }
        if (this.selected.getBasic().getIsBrick()) {
            boolean hasBrick = false;
            for (KObject o : this.selected.parent().inside()) {
                if (!o.getBasic().getIsBrick()) continue;
                hasBrick = true;
            }
            if (hasBrick) {
                this.addItemToPopup("glue bricks", popup);
            }
        }
        this.addItemToPopup("undo", popup);
        this.addItemToPopup("copy", popup);
        this.addItemToPopup("paste to cursor", popup);
        this.addItemToPopup("copy to cursor", popup);
        this.addItemToPopup("console", popup);
        this.addItemToPopup("show XML", popup);
        this.addItemToPopup("show Kisp", popup);
        Point p = frame.getJPanel().getLocationOnScreen();
        this.rightClickLocation = new Int2D(p.x + mouseX, p.y + mouseY);
        popup.show(this.popupFrame, this.rightClickLocation.getX(), this.rightClickLocation.getY());
    }

    private void addItemToPopup(String cmd, JPopupMenu popup) {
        JMenuItem menuItem = new JMenuItem(cmd);
        menuItem.addActionListener(this);
        menuItem.setActionCommand(cmd);
        popup.add(menuItem);
    }

    public void handleConsoleCmd(Console console, String cmd) {
        if ((cmd = cmd.trim()) == null || cmd.equals("")) {
            return;
        }
        if (cmd.charAt(0) == '!') {
            LinkedList<String> logs = this.cmd(cmd.substring(1).trim());
            for (String s : logs) {
                console.printString(s);
            }
        } else {
            Object o = null;
            Function f = new Function(cmd);
            o = f.getImplementation() instanceof FakeImplementation ? ((FakeImplementation)f.getImplementation()).get() : (f.getImplementation() instanceof ErroneousImplementation ? null : f);
            if (o != null) {
                KObjectFactory.insertKObjectToSystem((KObject)o, null);
                this.onCursor = o;
                this.onCursorClickPos = Int2D.zero;
                this.setSelected(this.onCursor);
                this.lastTimeCut = false;
                console.printString("Ok!");
            } else {
                console.printString("Neplatn\u00fd v\u00fdraz Kispu.");
            }
        }
    }

    public void setActualFigure(Figure f) {
        this.actualFigure = f;
    }

    private void changeFigure() {
        this.changeFigure(null);
    }

    private void changeFigure(Figure dontSelect) {
        if (this.selectedFrame == null) {
            return;
        }
        LinkedList<Figure> figureList = this.getFigureList();
        if (figureList.size() > 0) {
            this.figureIndex = (this.figureIndex + 1) % figureList.size();
            this.actualFigure = figureList.get(this.figureIndex);
            if (this.actualFigure == dontSelect) {
                this.actualFigure = figureList.get((this.figureIndex + 1) % figureList.size());
            }
            this.actualFigure.figureCmd(Figure.FigureCmd.up);
            this.actualFigure.figureCmd(Figure.FigureCmd.up);
        } else {
            this.actualFigure = null;
        }
    }

    private LinkedList<Figure> getFigureList() {
        KObject t = this.selectedFrame.getTarget();
        LinkedList<Figure> figureList = new LinkedList<Figure>();
        for (KObject o : t.inside()) {
            if (!(o instanceof Figure)) continue;
            figureList.add((Figure)((Object)o));
        }
        return figureList;
    }

    private void figureCmd(Figure.FigureCmd cmd) {
        if (this.actualFigure == null) {
            return;
        }
        if (this.actualFigure.parent() != this.selectedFrame.getTarget()) {
            return;
        }
        this.actualFigure.figureCmd(cmd);
    }

    private void allFigureCmd(Figure.FigureCmd cmd) {
        for (Figure b : this.getFigureList()) {
            b.figureCmd(cmd);
        }
    }

    private String load() {
        if (this.fileChooser.showOpenDialog(null) == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.changeXML(this.main.id(), file.getPath(), false);
            return "[LOAD] " + file.getPath();
        }
        return "[LOAD] Zru\u0161eno u\u017eivatelem.";
    }

    private String save() {
        if (this.fileChooser.showSaveDialog(null) == 0) {
            File file = this.fileChooser.getSelectedFile();
            StringBuilder sb = new StringBuilder();
            for (KObject o : ((Basic)this.main).inside()) {
                sb.append(o.toXml().toString());
            }
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kutil>\n" + sb.toString() + "</kutil>";
            try {
                String[] rows;
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                for (String row : rows = xml.split("\n")) {
                    out.write(row);
                    out.newLine();
                }
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return "[SAVE] " + file.getPath();
        }
        return "[SAVE] Zru\u0161eno u\u017eivatelem.";
    }

    private boolean rename(String oldId, String newId) {
        boolean succes = Global.idDB().rename(oldId, newId);
        if (!succes) {
            return false;
        }
        LinkedList<KObject> os = this.scheduler.getKObjects();
        for (KObject o : os) {
            o.resolveRenaming(oldId, newId);
        }
        return true;
    }

    private void renameDialog() {
        if (this.selected != null) {
            this.openConsole("!rename " + this.selected.id() + " ");
        }
    }

    private void saveStateToUndoBuffer() {
        if (this.main != null) {
            this.undoBuffer.addFirst(this.main.toXml().toString());
            this.redoBuffer.clear();
        }
    }

    private void undo() {
        if (this.main != null && !this.undoBuffer.isEmpty()) {
            String lastState = this.undoBuffer.getFirst();
            this.undoBuffer.removeFirst();
            this.redoBuffer.addFirst(this.main.toXml().toString());
            this.loadToMain(lastState);
        }
    }

    private void redo() {
        if (this.main != null && !this.redoBuffer.isEmpty()) {
            String nextState = this.redoBuffer.getFirst();
            this.redoBuffer.removeFirst();
            this.undoBuffer.addFirst(this.main.toXml().toString());
            this.loadToMain(nextState);
        }
    }

    private void loadToMain(String xmlString) {
        KObject parent = this.main.parent();
        this.main.delete();
        KObject o = KObjectFactory.newKObject(xmlString);
        parent.add(o);
        o.setParent(parent);
        this.isSimulationRunning = false;
    }

    private String changeBgcolor(String id, String rgb) {
        KObject obj = Global.idDB().get(id);
        if (obj == null || !(obj instanceof Basic)) {
            return "neplatn\u00e9 [id]";
        }
        ((Basic)obj).setBgcolor(Utils.parseColor(rgb));
        return "barva zm\u011bn\u011bna.";
    }

    private String changeActualFrameTarget(String id) {
        this.selectedFrame.resetTarget(id);
        return "Sand se povedlo zm\u011bnit id actualn\u00edho framu.";
    }

    private void changeXML(String id, String filename, boolean isInternal) {
        KObject obj = Global.idDB().get(id);
        if (obj == null || !(obj instanceof Basic)) {
            return;
        }
        if (obj instanceof Frame) {
            ((Frame)obj).setCam(Int2D.zero());
        }
        this.isSimulationRunning = false;
        Basic basic = (Basic)obj;
        basic.clearBeforeAdding();
        LinkedList<KObject> list = null;
        list = isInternal ? KObjectFactory.newKObjectFromResource(filename) : KObjectFactory.newKObjectFromFile(filename);
        for (KObject o : list) {
            KObjectFactory.insertKObjectToSystem(o, basic);
            basic.add(o);
        }
        this.undoBuffer.clear();
        this.redoBuffer.clear();
    }

    public void setMain(KObject o) {
        this.main = o;
    }

    private void openConsole() {
        if (this.console == null) {
            this.console = new Console(new Int2D(12, 26));
        } else {
            this.console.requestFocus();
        }
    }

    private void openConsole(String cmd) {
        this.openConsole();
        this.console.setCmd(cmd);
    }

    public void closeConsole() {
        this.console.getJFrame().dispose();
        this.console = null;
    }

    private void openEditor(String str) {
        Editor ed = new Editor(new Int2D(100, 100), str);
    }

    public void setFrom(Outputable f, int fp) {
        this.saveStateToUndoBuffer();
        this.from = f;
        this.fromPort = fp;
    }

    public Outputable getFrom() {
        return this.from;
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public final void resetFrom() {
        this.from = null;
        this.fromPort = -1;
    }

    public void copyToCursor(KObject o) {
        if (this.onCursor != null) {
            return;
        }
        KObject copy = o.copy();
        KObjectFactory.insertKObjectToSystem(copy, null);
        this.onCursor = copy;
        this.onCursorClickPos = Int2D.zero;
        this.setSelected(this.onCursor);
        this.lastTimeCut = false;
    }

    public void cutToCursor(KObject o, Int2D clickPos) {
        if (this.onCursor != null) {
            return;
        }
        KObject parent = o.parent();
        if (parent == null) {
            return;
        }
        this.saveStateToUndoBuffer();
        parent.remove(o);
        this.onCursor = o;
        this.onCursorClickPos = this.onCursor.pos().minus(clickPos);
        this.setSelected(this.onCursor);
        this.lastTimeCut = true;
    }

    private void fromXmlToCursor(String xmlStr) {
        KObject o;
        this.onCursor = o = KObjectFactory.newKObject(xmlStr);
        this.onCursorClickPos = Int2D.zero;
        this.setSelected(this.onCursor);
        this.lastTimeCut = false;
    }

    public void pasteFromCursor(KObject newParent, Int2D clickPos) {
        if (this.onCursor == null) {
            return;
        }
        Int2D pos = clickPos.plus(this.onCursorClickPos);
        if (((Basic)this.onCursor).getAlign15()) {
            pos = pos.align(15);
        }
        this.onCursor.setPos(pos);
        this.onCursor.setParent(newParent);
        newParent.add(this.onCursor);
        ((Basic)this.onCursor).setSpeed(Int2D.zero);
        KObject oldOnCursor = this.onCursor;
        this.onCursor = null;
        if (this.brushInsertMode) {
            this.copyToCursor(oldOnCursor);
        }
    }

    public boolean somethingOnCursor() {
        return this.onCursor != null;
    }

    public void onDrag(Int2D mousePos) {
        this.onDragPos = mousePos;
    }

    public void onDrag(MouseEvent e) {
        this.onDragAbsPos = new Int2D(e.getX(), e.getY());
    }

    public void onClick(MouseEvent e) {
        if (this.popupFrame != null) {
            this.popupFrame.dispose();
        }
    }

    public void onMove(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public void paintScreen(Graphics2D g) {
        try {
            if (this.lastTimeCut && this.onCursor != null) {
                Int2D center = this.onDragAbsPos.minus(this.onDragPos);
                Int2D objectPos = this.onDragPos.plus(this.onCursorClickPos);
                this.onCursor.setPos(objectPos);
                this.onCursor.drawOutside(g, center, 0);
            } else if (!this.lastTimeCut && this.onCursor != null) {
                this.onCursor.setPos(new Int2D(this.mouseX, this.mouseY));
                this.onCursor.drawOutside(g, Int2D.zero, 0);
            }
        }
        catch (NullPointerException e) {
            Log.it("Chycena v\u00fdjimka p\u0159i vykreslen\u00ed, nevad\u00ed.");
        }
    }

    public void setSelected(KObject o) {
        if (this.selected != null) {
            this.selected.setHighlighted(false);
        }
        this.selected = o;
        this.selected.setHighlighted(true);
        if (this.selected instanceof Figure) {
            this.setActualFigure((Figure)((Object)this.selected));
        }
        if (!(this.selected instanceof Inputable) && !(this.selected instanceof Outputable)) {
            this.resetFrom();
        }
    }

    public void setSelectedFrame(Frame f) {
        if (this.selectedFrame != null) {
            this.selectedFrame.setHighlightedFrame(false);
        }
        this.selectedFrame = f;
        this.selectedFrame.setHighlightedFrame(true);
    }

    private void enter() {
        String cmd;
        if (this.selected == null || this.selectedFrame == null) {
            return;
        }
        if (this.selected.getIsGuiStuff()) {
            return;
        }
        this.saveStateToUndoBuffer();
        this.selectedFrame.resetTarget(this.selected.id());
        this.selectedFrame.setCam(Int2D.zero());
        if (this.selected instanceof Basic && (cmd = ((Basic)this.selected).getOnEnterCmd()) != null) {
            this.cmd(cmd);
        }
    }

    private void backspace() {
        if (this.selectedFrame == null) {
            return;
        }
        if (this.selectedFrame.getTarget().parent() == null) {
            return;
        }
        if (this.selectedFrame.getTarget().getIsGuiStuff()) {
            return;
        }
        this.saveStateToUndoBuffer();
        this.selectedFrame.resetTarget(this.selectedFrame.getTarget().parent().id());
        this.selectedFrame.setCam(Int2D.zero());
    }

    private void delete() {
        if (this.selected == null) {
            return;
        }
        if (this.selected == this.selectedFrame) {
            return;
        }
        if (this.selected.getIsGuiStuff()) {
            return;
        }
        this.saveStateToUndoBuffer();
        this.selected.delete();
        if (this.selected == this.actualFigure) {
            this.changeFigure(this.actualFigure);
        }
        this.selected = null;
    }

    private void toggleShowInfo() {
        this.showInfo = !this.showInfo;
    }

    private void togglePausePlay() {
        boolean bl = this.isSimulationRunning = !this.isSimulationRunning;
        if (this.isSimulationRunning) {
            this.saveStateToUndoBuffer();
        }
    }

    private void changeInsertMode() {
        this.brushInsertMode = !this.brushInsertMode;
    }

    public boolean isSimulationRunning() {
        return this.isSimulationRunning;
    }

    public boolean showInfo() {
        return this.showInfo;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    protected void setScheduler(Scheduler s) {
        this.scheduler = s;
    }
}

