/*
 * Decompiled with CFR 0.152.
 */
package kutil.core;

import java.util.LinkedList;
import java.util.PriorityQueue;
import kutil.core.CalendarEvent;
import kutil.core.CalendarEventComparator;
import kutil.core.Global;
import kutil.core.KAtts;
import kutil.kobjects.KObject;
import kutil.kobjects.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scheduler {
    private PriorityQueue<CalendarEvent> calendar;
    private KAtts loaded;
    private static final boolean logXml = false;

    public Scheduler(KAtts l) {
        this.loaded = l;
        this.init(this.loaded);
    }

    private void init(KAtts kAtts) {
        this.calendar = new PriorityQueue<CalendarEvent>(3, new CalendarEventComparator());
        for (KObject o : kAtts.getList("times")) {
            this.calendar.add(new CalendarEvent((Time)o));
        }
        Global.rucksack().setScheduler(this);
        this.start();
    }

    public void terminate() {
        System.exit(0);
    }

    public LinkedList<KObject> getKObjects() {
        return this.loaded.getList("kutil");
    }

    private void start() {
        while (true) {
            long zacatekAkce = Scheduler.time();
            if (this.calendar.isEmpty()) break;
            CalendarEvent ce = this.calendar.poll();
            Time time = ce.time;
            if (time.isFinished()) continue;
            time.decrementIterations();
            time.step();
            this.calendar.add(new CalendarEvent(time, ce.when + time.getPeriod()));
            long trvalo = Scheduler.time() - zacatekAkce;
            if (this.calendar.isEmpty()) break;
            Scheduler.sleep(this.calendar.peek().when - (ce.when + trvalo));
        }
    }

    private static void sleep(long miliseconds) {
        if (miliseconds <= 0L) {
            return;
        }
        try {
            Thread.sleep(miliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static long time() {
        return System.nanoTime() / 1000000L;
    }

    public static String getXMLString(KAtts kAtts) {
        StringBuilder sb = new StringBuilder();
        sb.append("<kutil>\n");
        for (KObject o : kAtts.getList("kutil")) {
            sb.append(o.toXml().toString());
        }
        sb.append("</kutil>");
        return sb.toString();
    }
}

