/*
 * Decompiled with CFR 0.152.
 */
package kutil.functions;

import java.util.LinkedList;
import java.util.Stack;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.functions.AppleSensor;
import kutil.functions.BinarImplementation;
import kutil.functions.C2342;
import kutil.functions.C42;
import kutil.functions.Call;
import kutil.functions.ClockImplementation;
import kutil.functions.Const;
import kutil.functions.Copy;
import kutil.functions.Dec;
import kutil.functions.DirSides;
import kutil.functions.Div;
import kutil.functions.Div2;
import kutil.functions.Doubledot;
import kutil.functions.Doubledot2;
import kutil.functions.EqualsEquals;
import kutil.functions.ErroneousImplementation;
import kutil.functions.Eval;
import kutil.functions.FakeImplementation;
import kutil.functions.FlyCmd;
import kutil.functions.FlySensor;
import kutil.functions.FunctionImplemetation;
import kutil.functions.Get;
import kutil.functions.GetMem;
import kutil.functions.GoalSensorImplementation;
import kutil.functions.Head;
import kutil.functions.Id;
import kutil.functions.If;
import kutil.functions.Inc;
import kutil.functions.IncubatorImplementation;
import kutil.functions.Input;
import kutil.functions.Lambda;
import kutil.functions.LogXML;
import kutil.functions.Log_;
import kutil.functions.Minus;
import kutil.functions.Not;
import kutil.functions.Output;
import kutil.functions.Pair;
import kutil.functions.Plus;
import kutil.functions.Plus3;
import kutil.functions.PopMem;
import kutil.functions.PushMem;
import kutil.functions.Read;
import kutil.functions.Rot;
import kutil.functions.Rot180;
import kutil.functions.RotCW;
import kutil.functions.Set;
import kutil.functions.Tail;
import kutil.functions.Times;
import kutil.functions.TopMem;
import kutil.functions.TouchSensorImplementation;
import kutil.functions.UnarCall;
import kutil.functions.UnarEval;
import kutil.functions.UnarFromBinar;
import kutil.functions.UnarImplementation;
import kutil.functions.Unpair;
import kutil.functions.WaspSensor;
import kutil.functions.WebInput;
import kutil.functions.WebOutputImplementation;
import kutil.functions.Write;
import kutil.kobjects.Basic;
import kutil.kobjects.Bool;
import kutil.kobjects.Box;
import kutil.kobjects.Direction;
import kutil.kobjects.FFUnit;
import kutil.kobjects.Function;
import kutil.kobjects.In;
import kutil.kobjects.KObject;
import kutil.kobjects.KObjectFactory;
import kutil.kobjects.Num;
import kutil.kobjects.Out;
import kutil.kobjects.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kisp {
    private static FunctionImplemetation newAtomImplementation(String str, Function f) {
        if ("id".equals(str)) {
            return new Id();
        }
        if ("inc".equals(str)) {
            return new Inc();
        }
        if ("dec".equals(str)) {
            return new Dec();
        }
        if ("+".equals(str)) {
            return new Plus();
        }
        if ("*".equals(str)) {
            return new Times();
        }
        if ("-".equals(str)) {
            return new Minus();
        }
        if ("div".equals(str)) {
            return new Div();
        }
        if ("copy".equals(str)) {
            return new Copy();
        }
        if (":".equals(str)) {
            return new Doubledot();
        }
        if ("pair".equals(str)) {
            return new Pair();
        }
        if ("unpair".equals(str)) {
            return new Unpair();
        }
        if ("head".equals(str)) {
            return new Head();
        }
        if ("tail".equals(str)) {
            return new Tail();
        }
        if ("if".equals(str)) {
            return new If();
        }
        if ("not".equals(str)) {
            return new Not();
        }
        if ("==".equals(str)) {
            return new EqualsEquals();
        }
        if ("rotCW".equals(str)) {
            return new RotCW();
        }
        if ("rot180".equals(str)) {
            return new Rot180();
        }
        if ("rot".equals(str)) {
            return new Rot();
        }
        if ("dirSides".equals(str)) {
            return new DirSides();
        }
        if (":2".equals(str)) {
            return new Doubledot2();
        }
        if ("get".equals(str)) {
            return new Get();
        }
        if ("set".equals(str)) {
            return new Set();
        }
        if ("read".equals(str)) {
            return new Read(f);
        }
        if ("write".equals(str)) {
            return new Write(f);
        }
        if ("getMem".equals(str)) {
            return new GetMem(f);
        }
        if ("topMem".equals(str)) {
            return new TopMem(f);
        }
        if ("popMem".equals(str)) {
            return new PopMem(f);
        }
        if ("pushMem".equals(str)) {
            return new PushMem(f);
        }
        if ("call".equals(str)) {
            return new Call();
        }
        if ("eval".equals(str)) {
            return new Eval();
        }
        if ("const".equals(str)) {
            return new Const();
        }
        if ("webInput".equals(str)) {
            return new WebInput();
        }
        if ("webOutput".equals(str)) {
            return new WebOutputImplementation(f);
        }
        if ("clock".equals(str)) {
            return new ClockImplementation(f);
        }
        if ("incubator".equals(str)) {
            return new IncubatorImplementation(f);
        }
        if ("appleSensor".equals(str)) {
            return new AppleSensor(f);
        }
        if ("waspSensor".equals(str)) {
            return new WaspSensor(f);
        }
        if ("flySensor".equals(str)) {
            return new FlySensor(f);
        }
        if ("goalSensor".equals(str)) {
            return new GoalSensorImplementation(f);
        }
        if ("touchSensor".equals(str)) {
            return new TouchSensorImplementation(f);
        }
        if ("flyCmd".equals(str)) {
            return new FlyCmd(f);
        }
        if ("ffunit".equals(str)) {
            return new FFUnit.FFUnitImplementation(f);
        }
        if ("log".equals(str)) {
            return new Log_();
        }
        if ("logXML".equals(str)) {
            return new LogXML();
        }
        if ("div2".equals(str)) {
            return new Div2();
        }
        if ("c42".equals(str)) {
            return new C42();
        }
        if ("c2342".equals(str)) {
            return new C2342();
        }
        if ("plus3".equals(str)) {
            return new Plus3();
        }
        if ("input".equals(str)) {
            return new Input();
        }
        if ("output".equals(str)) {
            return new Output();
        }
        return null;
    }

    public static KObject atomicKispElement(String str) {
        if ("[true]".equals(str)) {
            return new Bool(true);
        }
        if ("[false]".equals(str)) {
            return new Bool(false);
        }
        if ("[left]".equals(str)) {
            return new Direction(Direction.Vals.left);
        }
        if ("[right]".equals(str)) {
            return new Direction(Direction.Vals.right);
        }
        if ("[up]".equals(str)) {
            return new Direction(Direction.Vals.up);
        }
        if ("[down]".equals(str)) {
            return new Direction(Direction.Vals.down);
        }
        if ("[randdir]".equals(str)) {
            return new Direction(Direction.Vals.randdir);
        }
        return null;
    }

    public static FunctionImplemetation newImplementation(String str, Function f) {
        if (str == null) {
            return new Id();
        }
        if ((str = Kisp.iqTrim(str)).equals("")) {
            return new Id();
        }
        if (Kisp.isLambdaTerm(str)) {
            LinkedList<String> parts = Kisp.iqSplit(Kisp.iqTrim(str));
            String var = parts.get(1);
            String body = parts.get(2);
            return new Lambda(var, body, f);
        }
        int lastSpace = Kisp.cutLastBracketSegment(str);
        if (lastSpace != -1) {
            String part1 = str.substring(0, lastSpace);
            String part2 = str.substring(lastSpace + 1);
            if (part1.equals("'")) {
                KObject o = Kisp.fromString(part2);
                KObjectFactory.insertKObjectToSystem(o, null);
                return new FakeImplementation(o);
            }
            FunctionImplemetation operator = Kisp.newImplementation(part1, f);
            FunctionImplemetation operand = Kisp.newImplementation(part2, f);
            if (operator instanceof ErroneousImplementation || operand instanceof ErroneousImplementation) {
                return new ErroneousImplementation();
            }
            if (operator instanceof Call) {
                return new UnarCall(Kisp.getArg(operand), str);
            }
            if (operator instanceof UnarCall) {
                UnarCall uc = (UnarCall)operator;
                Function fce = (Function)KObjectFactory.insertKObjectToSystem(new Function(uc.title()), null);
                return new FakeImplementation(fce.call(new KObject[]{Kisp.getArg(operand)})[0]);
            }
            if (operator instanceof FakeImplementation) {
                KObject o = ((FakeImplementation)operator).get();
                if (o instanceof Symbol) {
                    Symbol s = (Symbol)o;
                    KObject target = Global.idDB().get(s.get());
                    if (target != null && target instanceof Function) {
                        Function fce = (Function)target;
                        return new FakeImplementation(fce.call(new KObject[]{Kisp.getArg(operand)})[0]);
                    }
                }
                return new ErroneousImplementation();
            }
            if (operator instanceof Eval) {
                return new UnarEval(Kisp.getArg(operand), str);
            }
            if (operator instanceof Lambda) {
                Lambda lambda = (Lambda)operator;
                return lambda.betaReduction(Kisp.getArg(operand));
            }
            if (operator instanceof UnarImplementation) {
                UnarImplementation ui = (UnarImplementation)operator;
                return new FakeImplementation(ui.compute(Kisp.getArg(operand)));
            }
            if (operator instanceof BinarImplementation) {
                BinarImplementation bi = (BinarImplementation)operator;
                return new UnarFromBinar(bi, Kisp.getArg(operand), str, 0);
            }
            return new ErroneousImplementation();
        }
        if (str.matches("[-]?[0-9]+") || str.matches("(\\[)(.)*(\\])")) {
            KObject o = KObjectFactory.insertKObjectToSystem(Kisp.fromString(str), null);
            return new FakeImplementation(o);
        }
        if (str.equals("in")) {
            return new FakeImplementation(new In());
        }
        if (str.equals("out")) {
            return new FakeImplementation(new Out());
        }
        FunctionImplemetation ret = Kisp.newAtomImplementation(str, f);
        if (ret == null) {
            return new FakeImplementation(new Symbol(str));
        }
        return ret;
    }

    private static KObject getArg(FunctionImplemetation fi) {
        if (fi instanceof FakeImplementation) {
            return ((FakeImplementation)fi).get();
        }
        return new Function(fi.title());
    }

    private static int cutLastBracketSegment(String str) {
        int numBrackets = 0;
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) == ')') {
                ++numBrackets;
                continue;
            }
            if (str.charAt(i) == '(') {
                --numBrackets;
                continue;
            }
            if (str.charAt(i) != ' ' || numBrackets != 0 || i > 1 && str.charAt(i - 1) == '\'') continue;
            return i;
        }
        return -1;
    }

    private static LinkedList<String> iqSplit(String str) {
        LinkedList<String> ret = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        int numBrackets = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '(') {
                ++numBrackets;
            } else if (str.charAt(i) == ')') {
                --numBrackets;
            } else if (str.charAt(i) == ' ' && numBrackets == 0) {
                ret.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(str.charAt(i));
        }
        if (sb.length() > 0) {
            ret.add(sb.toString());
        }
        return ret;
    }

    public static String iqTrim(String str) {
        if (str == null) {
            return str;
        }
        if ((str = str.replaceAll("\\(", " ( ").replaceAll("\\)", " ) ").replaceAll("'", " ' ").replaceAll("\\\\", " \\\\ ").replaceAll("\\s+", " ").trim()).equals("")) {
            return str;
        }
        if (str.charAt(0) != '(') {
            return str;
        }
        int numOpenBrackets = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '(') {
                ++numOpenBrackets;
            } else if (str.charAt(i) == ')') {
                --numOpenBrackets;
            }
            if (numOpenBrackets != 0 || i >= str.length() - 1) continue;
            return str;
        }
        if (numOpenBrackets == 0) {
            return Kisp.iqTrim(str.substring(1, str.length() - 1));
        }
        return str;
    }

    private static boolean isLambdaTerm(String str) {
        LinkedList<String> parts = Kisp.iqSplit(Kisp.iqTrim(str));
        if (parts.size() != 3) {
            return false;
        }
        return parts.getFirst().equals("\\");
    }

    public static KObject fromString(String str) {
        String[] parts = str.replaceAll("\\(", " ( ").replaceAll("\\)", " ) ").trim().split("\\s+");
        if (parts.length > 1 && !parts[0].equals("(")) {
            return Kisp.fromString("(" + str + ")");
        }
        Stack<Box> stack = new Stack<Box>();
        Stack<Int2D> posStack = new Stack<Int2D>();
        for (int i = 0; i < parts.length; ++i) {
            Int2D pos;
            Box peek;
            String part = parts[i];
            if ("(".equals(part)) {
                Box b = new Box();
                b.setPosDirect(new Int2D(100, 100));
                stack.push(b);
                posStack.push(new Int2D(100, 100));
                continue;
            }
            if (")".equals(part)) {
                if (stack.empty()) {
                    return null;
                }
                Box box = (Box)stack.pop();
                posStack.pop();
                if (stack.empty()) {
                    if (i < parts.length - 1) {
                        return null;
                    }
                    return box;
                }
                peek = (Box)stack.peek();
                pos = (Int2D)posStack.peek();
                box.setPosDirect(pos.copy());
                pos.adjustX(75);
                peek.directAdd(box);
                continue;
            }
            if (part.matches("[-]?[0-9]+")) {
                Num num = new Num(Integer.parseInt(part));
                if (stack.empty()) {
                    if (i < parts.length - 1) {
                        return null;
                    }
                    return num;
                }
                peek = (Box)stack.peek();
                pos = (Int2D)posStack.peek();
                num.setPosDirect(pos.copy());
                pos.adjustX(50);
                peek.directAdd(num);
                continue;
            }
            if (part.matches("(\\[)(.)*(\\])")) {
                KObject ko = Kisp.atomicKispElement(part);
                if (ko == null || !(ko instanceof Basic)) {
                    return null;
                }
                Basic o = (Basic)ko;
                if (stack.empty()) {
                    if (i < parts.length - 1) {
                        return null;
                    }
                    return o;
                }
                Box peek2 = (Box)stack.peek();
                Int2D pos2 = (Int2D)posStack.peek();
                o.setPosDirect(pos2.copy().plus(new Int2D(-26, -23)));
                pos2.adjustX(60);
                peek2.directAdd(o);
                continue;
            }
            Symbol sym = new Symbol(part);
            if (stack.empty()) {
                if (i < parts.length - 1) {
                    return null;
                }
                return sym;
            }
            peek = (Box)stack.peek();
            pos = (Int2D)posStack.peek();
            sym.setPosDirect(pos.copy().plus(new Int2D(-15, -16)));
            pos.adjustX(sym.getWidth() + 20);
            peek.directAdd(sym);
        }
        return null;
    }
}

