/*
 * Decompiled with CFR 0.152.
 */
package kutil.functions;

import kutil.functions.FakeImplementation;
import kutil.functions.FunctionImplemetation;
import kutil.functions.Kisp;
import kutil.kobjects.Function;
import kutil.kobjects.KObject;
import kutil.kobjects.KObjectFactory;

public class Lambda
implements FunctionImplemetation {
    private String body;
    private Function f;
    private String[] vars;
    private String title;
    private int titleShift;

    public Lambda(String var, String body, Function f) {
        this.title = "\\ " + var + " " + body;
        this.titleShift = 0;
        this.body = body;
        this.f = f;
        this.vars = Kisp.iqTrim(var).split(" ");
    }

    public String title() {
        return this.title;
    }

    public int getTitleShift() {
        return this.titleShift;
    }

    public int numArgs() {
        return this.vars.length;
    }

    public int numOutputs() {
        return 1;
    }

    public FunctionImplemetation betaReduction(KObject o) {
        String expr = this.body.replaceAll(this.vars[0], "( ' " + o.toKisp() + " )");
        if (this.vars.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < this.vars.length; ++i) {
                sb.append(this.vars[i]);
                sb.append(" ");
            }
            expr = "\\ ( " + sb.toString() + ") " + expr;
        }
        FunctionImplemetation fi = Kisp.newImplementation(expr, this.f);
        return fi;
    }

    public KObject[] compute(KObject[] objects) {
        FunctionImplemetation fi = this;
        for (int i = 0; i < objects.length; ++i) {
            fi = fi.betaReduction(objects[i]);
        }
        if (fi instanceof FakeImplementation) {
            KObject ret = ((FakeImplementation)fi).get();
            KObjectFactory.insertKObjectToSystem(ret, null);
            return new KObject[]{ret};
        }
        Function ret = new Function(fi.title());
        KObjectFactory.insertKObjectToSystem(ret, null);
        return new KObject[]{ret};
    }
}

