/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.LinkedList;
import kutil.core.Global;
import kutil.core.IdDB;
import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.core.Rucksack;
import kutil.items.BooleanItem;
import kutil.items.Int2DItem;
import kutil.items.Items;
import kutil.items.ListItem;
import kutil.items.StringItem;
import kutil.kevents.ClickEvent;
import kutil.kevents.DragEvent;
import kutil.kevents.KEvent;
import kutil.kevents.ReleaseEvent;
import kutil.kobjects.Field;
import kutil.kobjects.Frame;
import kutil.kobjects.KObject;
import kutil.kobjects.KObjectFactory;
import kutil.kobjects.MultiObject;
import kutil.shapes.KShape;
import kutil.xml.Xml;
import kutil.xml.XmlElement;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.StaticBody;
import net.phys2d.raw.World;
import net.phys2d.raw.strategies.QuadSpaceStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Basic
implements KObject {
    private Items items = new Items();
    private StringItem type;
    private StringItem id;
    private Int2DItem pos;
    private StringItem shapeCmd;
    private BooleanItem physical;
    private BooleanItem rotable;
    private BooleanItem attached;
    private BooleanItem movable;
    private StringItem bgcolorCmd;
    private BooleanItem main;
    private BooleanItem takable;
    private BooleanItem guiStuff;
    private StringItem onInit;
    private StringItem onEnter;
    private StringItem ffType;
    private BooleanItem align15;
    private BooleanItem isBrick;
    private ListItem inside;
    private KObject parent;
    private KShape shape;
    private double rot;
    private Color bgcolor;
    private boolean isHighlighted;
    private World world;
    private Body body;
    private LinkedList<KObject> objectsToAdd;
    private LinkedList<KObject> objectsToAddFirst;
    private LinkedList<KObject> objectsToRemove;
    private String oldCopyId;
    private boolean stepInside;
    private boolean isAffectedByGravity;
    private boolean isInitialised;
    private boolean clearItAfterAdding;
    private boolean clearItBeforeAdding;

    public Basic(KAtts kAtts) {
        this.type = this.items.addString(kAtts, "type", null);
        this.id = this.items.addString(kAtts, "id", null);
        this.pos = this.items.addInt2D(kAtts, "pos", Int2D.zero());
        this.shapeCmd = this.items.addString(kAtts, "shape", null);
        this.bgcolorCmd = this.items.addString(kAtts, "bgcolor", null);
        this.physical = this.items.addBoolean(kAtts, "physical", false);
        this.rotable = this.items.addBoolean(kAtts, "rotable", false);
        this.attached = this.items.addBoolean(kAtts, "attached", false);
        this.movable = this.items.addBoolean(kAtts, "movable", true);
        this.main = this.items.addBoolean(kAtts, "main", false);
        this.takable = this.items.addBoolean(kAtts, "takable", true);
        this.guiStuff = this.items.addBoolean(kAtts, "guiStuff", false);
        this.onInit = this.items.addString(kAtts, "onInit", null);
        this.onEnter = this.items.addString(kAtts, "onEnter", null);
        this.ffType = this.items.addString(kAtts, "ffType", null);
        this.align15 = this.items.addBoolean(kAtts, "align15", false);
        this.isBrick = this.items.addBoolean(kAtts, "isBrick", false);
        this.inside = this.items.addList(kAtts, "inside");
        this.create();
    }

    public Basic() {
        this.type = this.items.addString("type", null);
        this.id = this.items.addString("id", null);
        this.pos = this.items.addInt2D("pos", Int2D.zero());
        this.shapeCmd = this.items.addString("shape", null);
        this.bgcolorCmd = this.items.addString("bgcolor", null);
        this.physical = this.items.addBoolean("physical", false, false);
        this.rotable = this.items.addBoolean("rotable", false, false);
        this.attached = this.items.addBoolean("attached", false, false);
        this.movable = this.items.addBoolean("movable", true, true);
        this.main = this.items.addBoolean("main", false, false);
        this.takable = this.items.addBoolean("takable", true, true);
        this.guiStuff = this.items.addBoolean("guiStuff", false, false);
        this.onInit = this.items.addString("onInit", null);
        this.onEnter = this.items.addString("onEnter", null);
        this.ffType = this.items.addString("ffType", null);
        this.align15 = this.items.addBoolean("align15", false, false);
        this.isBrick = this.items.addBoolean("isBrick", false, false);
        this.inside = this.items.addEmptyList("inside");
        this.create();
    }

    public Basic(Basic b) {
        this.type = this.items.addString("type", null);
        this.id = this.items.addString("id", null);
        this.pos = this.items.addInt2D("pos", b.pos.get().copy());
        this.shapeCmd = this.items.addString("shape", b.shapeCmd.get());
        this.bgcolorCmd = this.items.addString("bgcolor", b.bgcolorCmd.get());
        this.physical = this.items.addBoolean("physical", b.physical.get(), false);
        this.rotable = this.items.addBoolean("rotable", b.rotable.get(), false);
        this.attached = this.items.addBoolean("attached", b.attached.get(), false);
        this.movable = this.items.addBoolean("movable", b.movable.get(), true);
        this.main = this.items.addBoolean("main", b.main.get(), false);
        this.takable = this.items.addBoolean("takable", b.takable.get(), true);
        this.guiStuff = this.items.addBoolean("guiStuff", b.guiStuff.get(), false);
        this.onInit = this.items.addString("onInit", b.onInit.get());
        this.onEnter = this.items.addString("onEnter", b.onEnter.get());
        this.ffType = this.items.addString("ffType", b.ffType.get());
        this.align15 = this.items.addBoolean("align15", b.align15.get(), false);
        this.isBrick = this.items.addBoolean("isBrick", b.isBrick.get(), false);
        this.inside = this.items.addEmptyList("inside");
        for (KObject o : b.inside()) {
            KObject copy = o.copy();
            this.inside.get().add(copy);
        }
        this.oldCopyId = b.id();
        this.create();
    }

    @Override
    public KObject copy() {
        return new Basic(this);
    }

    private void create() {
        this.isInitialised = false;
        this.clearItAfterAdding = false;
        this.clearItBeforeAdding = false;
        if (this.main.get()) {
            Global.rucksack().setMain(this);
        }
        this.shape = Global.shapeFactory().newKShape(this.shapeCmd.get());
        if (this.bgcolorCmd.get() != null) {
            String[] part = this.bgcolorCmd.get().split(" ");
            this.bgcolor = new Color(Integer.parseInt(part[0]), Integer.parseInt(part[1]), Integer.parseInt(part[2]));
        } else {
            this.bgcolor = Color.white;
        }
        if (this.align15.get()) {
            this.pos.set(this.pos.get().align(15));
        }
        this.rot = 0.0;
        this.isHighlighted = false;
        this.stepInside = true;
        this.isAffectedByGravity = true;
        this.world = new World(new Vector2f(0.0f, 10.0f), 10, new QuadSpaceStrategy(20, 5));
        this.objectsToAdd = new LinkedList();
        this.objectsToAddFirst = new LinkedList();
        this.objectsToRemove = new LinkedList();
    }

    @Override
    public void parentInfo(KObject parent) {
        this.parent = parent;
        for (KObject o : this.inside.get()) {
            o.parentInfo(this);
        }
    }

    @Override
    public void init() {
        if (this.isInitialised) {
            return;
        }
        this.isInitialised = true;
        if (this.id.get() == null) {
            this.id.set(this.idDB().getUniqueID());
            this.idDB().put(this.id.get(), this);
        }
        if (this.isCopied()) {
            Global.idChangeDB().put(this.oldCopyId, this.id.get());
        }
        if (this.physical.get()) {
            this.body = this.attached.get() ? new StaticBody(this.shape.getPhys2dShape()) : new Body(this.shape.getPhys2dShape(), 100.0f);
            this.body.setGravityEffected(this.isAffectedByGravity);
            this.body.setRotatable(this.rotable.get());
            this.body.setUserData(this);
            this.setBodyPos(this.pos.get());
            World parentWorld = this.getParentWorld();
            if (parentWorld != null) {
                parentWorld.add(this.body);
            }
        }
        if (this.onInit.get() != null) {
            Global.rucksack().cmd(this.onInit.get());
        }
        for (KObject o : this.inside.get()) {
            o.init();
        }
    }

    @Override
    public Xml toXml() {
        XmlElement ret = new XmlElement("object");
        this.items.addAttsToXmlElement(ret);
        return ret;
    }

    @Override
    public String toKisp() {
        StringBuilder sb = new StringBuilder();
        sb.append("( ");
        for (KObject o : this.inside.get()) {
            sb.append(o.toKisp());
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Basic getBasic() {
        return this;
    }

    @Override
    public void step() {
        if (this.physical.get()) {
            this.pos.set(this.shape.getPosByPhys2dCenter(this.body.getPosition()));
            this.rot = this.body.getRotation();
        }
        if (this.stepInside && Global.rucksack().isSimulationRunning() && this.world.getBodies().size() > 0) {
            this.world.step();
            this.world.step();
            this.world.step();
            this.world.step();
            this.world.step();
        }
        if (this.clearItBeforeAdding) {
            this.internalClear();
            this.clearItBeforeAdding = false;
        }
        if (!this.objectsToRemove.isEmpty()) {
            this.internalRemove();
        }
        if (!this.objectsToAdd.isEmpty()) {
            this.internalAdd();
        }
        if (!this.objectsToAddFirst.isEmpty()) {
            this.internalAddFirst();
        }
        if (this.clearItAfterAdding) {
            this.internalClear();
            this.clearItAfterAdding = false;
        }
        if (this.stepInside) {
            for (KObject o : this.inside.get()) {
                o.step();
                if (!(o instanceof Field)) continue;
                this.manageField((Field)o);
            }
        }
    }

    private void manageField(Field field) {
        for (KObject ob : this.inside.get()) {
            if (ob instanceof Field || !field.isVisitedBy(ob)) continue;
            field.reactToObjectPresence(ob);
        }
    }

    public void setStepInside(boolean b) {
        this.stepInside = b;
    }

    public boolean getStepInside() {
        return this.stepInside;
    }

    public void setIsAffectedByGravity(boolean b) {
        this.isAffectedByGravity = b;
    }

    public boolean isTakable() {
        return this.takable.get();
    }

    public String getOnEnterCmd() {
        return this.onEnter.get();
    }

    public String getFFType() {
        return this.ffType.get();
    }

    public boolean getAlign15() {
        return this.align15.get();
    }

    @Override
    public String cmd(String cmd) {
        String[] parts = cmd.split("\\s+");
        String cmdName = parts[0];
        if (this instanceof Frame) {
            Frame thisFrame = (Frame)this;
            if ("changeFrameTarget".equals(cmdName)) {
                thisFrame.resetTarget(parts[1]);
                return "Frame target zm\u011bn\u011bn na " + parts[1] + ".";
            }
            if ("showXML".equals(cmdName)) {
                thisFrame.toggleShowXML();
                return "P\u0159epnuto.";
            }
        }
        return "Neplatn\u00fd p\u0159\u00edkaz pro objekt " + this.id() + ".";
    }

    public boolean isCopied() {
        return this.oldCopyId != null;
    }

    @Override
    public void resolveCopying() {
        if (this.isCopied()) {
            for (KObject o : this.inside.get()) {
                o.resolveCopying();
            }
        }
    }

    @Override
    public void resolveRenaming(String oldId, String newId) {
        for (KObject o : this.inside.get()) {
            o.resolveRenaming(oldId, newId);
        }
        if (this.id.get().equals(oldId)) {
            this.id.set(newId);
        }
    }

    public World getParentWorld() {
        if (this.parent != null) {
            return this.parent.getWorld();
        }
        return null;
    }

    public String getInfoString() {
        return this.id.get() + " [" + this.pos.get() + "]";
    }

    @Override
    public LinkedList<KObject> inside() {
        return this.inside.get();
    }

    public ListItem insideItem() {
        return this.inside;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public boolean isPhysical() {
        return this.physical.get();
    }

    private void setBodyPos(Int2D newPos) {
        if (this.body == null) {
            return;
        }
        ROVector2f bodyPos = this.shape.getPhys2dCenter(newPos);
        this.body.setPosition(bodyPos.getX(), bodyPos.getY());
    }

    @Override
    public KObject parent() {
        return this.parent;
    }

    @Override
    public void setParent(KObject newParent) {
        this.parent = newParent;
    }

    @Override
    public Color bgcolor() {
        return this.bgcolor;
    }

    public void setBgcolor(Color c) {
        this.bgcolorCmd.set(c.getRed() + " " + c.getGreen() + " " + c.getBlue());
        this.bgcolor = c;
    }

    public void setType(String t) {
        this.type.set(t);
    }

    public void setPhysical(boolean p) {
        this.physical.set(p);
    }

    public void setAttached(boolean a) {
        this.attached.set(a);
    }

    public void setMovable(boolean b) {
        this.movable.set(b);
    }

    public void setShape(KShape s) {
        this.shape = s;
    }

    public KShape getShape() {
        return this.shape;
    }

    public boolean getIsRotable() {
        return this.rotable.get();
    }

    @Override
    public boolean getIsGuiStuff() {
        return this.guiStuff.get();
    }

    public boolean getIsBrick() {
        return this.isBrick.get();
    }

    public void setIsGuiStuff(boolean b) {
        this.guiStuff.set(b);
    }

    @Override
    public boolean getIsMovable() {
        return this.movable.get();
    }

    public void setIsRotable(boolean b) {
        this.rotable.set(b);
    }

    @Override
    public String id() {
        return this.id.get();
    }

    public final IdDB idDB() {
        return Global.idDB();
    }

    public final Rucksack rucksack() {
        return Global.rucksack();
    }

    public Items items() {
        return this.items;
    }

    @Override
    public Int2D pos() {
        return this.pos.get();
    }

    public double getRot() {
        return this.rot;
    }

    @Override
    public void setPos(Int2D p) {
        this.pos.set(p);
        this.setBodyPos(p);
    }

    public void setSpeed(Int2D v) {
        if (this.body == null) {
            return;
        }
        ROVector2f vel = this.body.getVelocity();
        this.body.adjustVelocity(new Vector2f((float)v.getX() - vel.getX(), (float)v.getY() - vel.getY()));
    }

    public void setPosDirect(Int2D p) {
        this.pos.set(p);
    }

    @Override
    public void setHighlighted(boolean isHighlighted) {
        this.isHighlighted = isHighlighted;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Override
    public void drawInside(Graphics2D g, Int2D center, int frameDepth) {
        for (KObject o : this.inside.get()) {
            o.drawOutside(g, center, frameDepth);
        }
    }

    @Override
    public void drawOutside(Graphics2D g, Int2D center, int frameDepth) {
        this.shape.draw(g, this.isHighlighted, this.getInfoString(), this.pos.get(), center, this.rot, this.rotable.get());
    }

    @Override
    public boolean isHit(Int2D clickPos) {
        return this.shape.isHit(this.pos.get(), clickPos, this.rot);
    }

    @Override
    public void event(KEvent kEvent) {
        if (kEvent instanceof ClickEvent) {
            this.clickEvent((ClickEvent)kEvent);
        } else if (kEvent instanceof DragEvent) {
            this.dragEvent((DragEvent)kEvent);
        } else if (kEvent instanceof ReleaseEvent) {
            this.releaseEvenent((ReleaseEvent)kEvent);
        }
    }

    private void clickEvent(ClickEvent e) {
        this.rucksack().setSelectedFrame(e.getFrame());
        Iterator<KObject> iter = this.inside.get().descendingIterator();
        while (iter.hasNext()) {
            KObject o = iter.next();
            if (!o.isHit(e.getPos())) continue;
            o.click(e.getPos());
            return;
        }
        this.rucksack().setSelected(e.getFrame());
    }

    private void dragEvent(DragEvent e) {
        this.rucksack().setSelectedFrame(e.getFrame());
        this.rucksack().onDrag(e.getPos());
        Iterator<KObject> iter = this.inside.get().descendingIterator();
        while (iter.hasNext()) {
            KObject o = iter.next();
            if (!o.isHit(e.getPos())) continue;
            o.drag(e.getPos(), e.getDelta(), e.getFrame());
            return;
        }
        if (!this.rucksack().somethingOnCursor()) {
            e.getFrame().moveCam(e.getDelta());
        }
        this.rucksack().setSelected(e.getFrame());
    }

    private void releaseEvenent(ReleaseEvent e) {
        Iterator<KObject> iter = this.inside.get().descendingIterator();
        while (iter.hasNext()) {
            KObject o = iter.next();
            if (!o.isHit(e.getPos())) continue;
            if (!(this instanceof Frame) && !o.getIsMovable()) {
                this.rucksack().pasteFromCursor(this, e.getPos());
                return;
            }
            o.release(e.getPos(), this);
            return;
        }
        this.rucksack().pasteFromCursor(this, e.getPos());
    }

    @Override
    public void drag(Int2D clickPos, Int2D delta, Frame f) {
        if (this.movable.get()) {
            this.rucksack().cutToCursor(this, clickPos);
        } else {
            if (this.rucksack().somethingOnCursor()) {
                return;
            }
            this.rucksack().setSelected(this);
            f.moveCam(delta);
        }
    }

    @Override
    public void click(Int2D clickPos) {
        this.rucksack().setSelected(this);
    }

    @Override
    public void release(Int2D clickPos, KObject obj) {
        this.rucksack().pasteFromCursor(obj, clickPos);
    }

    @Override
    public void delete() {
        this.remove();
        this.idDB().remove(this.id());
    }

    @Override
    public void remove() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public void remove(KObject o) {
        this.objectsToRemove.add(o);
    }

    @Override
    public void add(KObject o) {
        this.objectsToAdd.add(o);
    }

    @Override
    public void addFirst(KObject o) {
        this.objectsToAddFirst.add(o);
    }

    @Override
    public KObject popFirst() {
        if (this.inside.get().isEmpty()) {
            return null;
        }
        KObject first = this.inside.get().getFirst();
        this.remove(first);
        return first;
    }

    public KObject popLast() {
        if (this.inside.get().isEmpty()) {
            return null;
        }
        KObject last = this.inside.get().getLast();
        this.remove(last);
        return last;
    }

    public void directAdd(KObject o) {
        this.inside.get().add(o);
    }

    public void directAddFirst(KObject o) {
        this.inside.get().addFirst(o);
    }

    public void directClear() {
        this.inside.get().clear();
    }

    public void clearAfterAdding() {
        this.clearItAfterAdding = true;
    }

    public void clearBeforeAdding() {
        this.clearItBeforeAdding = true;
    }

    private void internalClear() {
        this.inside().clear();
        this.world.clear();
    }

    private void internalAdd() {
        for (KObject o : this.objectsToAdd) {
            if (o.isPhysical()) {
                this.world.add(o.getBody());
            }
            this.inside.get().add(o);
        }
        this.objectsToAdd.clear();
    }

    private void internalAddFirst() {
        for (KObject o : this.objectsToAddFirst) {
            if (o.isPhysical()) {
                this.world.add(o.getBody());
            }
            this.inside.get().addFirst(o);
        }
        this.objectsToAddFirst.clear();
    }

    private void internalRemove() {
        for (KObject o : this.objectsToRemove) {
            for (KObject f : this.inside.get()) {
                if (!(f instanceof Field)) continue;
                ((Field)f).informFieldAboutDeletation(o);
            }
            if (o.isPhysical()) {
                this.world.remove(o.getBody());
            }
            this.inside.get().remove(o);
        }
        this.objectsToRemove.clear();
    }

    @Override
    public void setPhysicalOff() {
        if (this.isPhysical()) {
            this.getParentWorld().remove(this.getBody());
            this.physical.set(false);
        }
    }

    @Override
    public void setPhysicalOn() {
        if (!this.isPhysical()) {
            this.getParentWorld().remove(this.getBody());
            this.physical.set(true);
            this.setBodyPos(this.pos());
            this.getParentWorld().add(this.body);
        }
    }

    public void glueBricks() {
        LinkedList<KObject> bricks = new LinkedList<KObject>();
        for (KObject o : this.parent().inside()) {
            if (!o.getBasic().getIsBrick()) continue;
            o.remove();
            bricks.add(o);
        }
        MultiObject multi = new MultiObject(bricks);
        multi.setPhysical(true);
        multi.getBasic().align15.set(true);
        KObjectFactory.insertKObjectToSystem(multi, null);
        multi.setParent(this.parent());
        this.parent().add(multi);
    }
}

