/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import kutil.core.Global;
import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.kobjects.Basic;
import kutil.kobjects.BudhaCollisionListener;
import kutil.kobjects.Figure;
import kutil.kobjects.KObject;
import kutil.shapes.BudhaShape;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.World;

public class Budha
extends Basic
implements Figure {
    private World parentWorld;
    private BudhaCollisionListener listener;
    private static final float KROK = 5.0f;
    private static final Vector2f KROK_NAHORU = new Vector2f(0.0f, -10.0f);
    private static final Vector2f KROK_DOLEVA = new Vector2f(-5.0f, -5.0f);
    private static final Vector2f KROK_DOPRAVA = new Vector2f(5.0f, -5.0f);
    private static final Int2D shiftBudha = new Int2D(0, -50);
    private static final Int2D shiftObject = new Int2D(0, 60);
    private KObject touched;

    public Budha(KAtts kAtts) {
        super(kAtts);
        this.create();
    }

    public Budha(Budha b) {
        super(b);
        this.create();
    }

    public KObject copy() {
        return new Budha(this);
    }

    private boolean isFreezed() {
        if (this.parent() instanceof Basic) {
            return !((Basic)this.parent()).getStepInside();
        }
        return true;
    }

    private void create() {
        this.setType("budha");
        this.setPhysical(true);
        this.setAttached(false);
        this.setShape(new BudhaShape(this));
        this.setStepInside(false);
        Global.rucksack().setActualFigure(this);
    }

    public void step() {
        super.step();
    }

    public void setParent(KObject newParent) {
        super.setParent(newParent);
        this.resetCollisionListener();
    }

    public void init() {
        super.init();
        this.resetCollisionListener();
    }

    private void resetCollisionListener() {
        if (this.parentWorld != null) {
            this.parentWorld.removeListener(this.listener);
        }
        this.parentWorld = this.getParentWorld();
        if (this.parentWorld != null) {
            this.listener = new BudhaCollisionListener(this);
            this.parentWorld.addListener(this.listener);
        }
    }

    public void figureCmd(Figure.FigureCmd cmd) {
        if (this.isFreezed() || !Global.rucksack().isSimulationRunning()) {
            return;
        }
        switch (cmd) {
            case left: {
                this.touched = null;
                if (this.getBody().getVelocity().getY() > 0.1f) {
                    this.getBody().adjustVelocity(KROK_DOLEVA);
                    break;
                }
                if (!(this.getBody().getVelocity().length() < 10.0f)) break;
                this.getBody().adjustVelocity(KROK_DOLEVA);
                break;
            }
            case right: {
                this.touched = null;
                if (this.getBody().getVelocity().getY() > 0.1f) {
                    this.getBody().adjustVelocity(KROK_DOPRAVA);
                    break;
                }
                if (!(this.getBody().getVelocity().length() < 10.0f)) break;
                this.getBody().adjustVelocity(KROK_DOPRAVA);
                break;
            }
            case up: {
                this.touched = null;
                if (this.getBody().getVelocity().getY() > -20.0f) {
                    this.getBody().adjustVelocity(KROK_NAHORU);
                }
                while (this.getBody().getVelocity().getY() > -1.0f) {
                    this.getBody().adjustVelocity(KROK_NAHORU);
                }
                break;
            }
            case down: {
                if (this.touched != null) {
                    this.moveToBudha(this.touched);
                    this.touched = null;
                    break;
                }
                this.moveFromBudha();
                break;
            }
            case shiftDown: {
                if (this.touched != null) {
                    this.moveDeepToBudha(this.touched);
                    this.touched = null;
                    break;
                }
                this.moveDeepFromBudha();
                break;
            }
            case shiftLeft: {
                this.rotateInsideLeft();
                break;
            }
            case shiftRight: {
                this.rotateInsideRight();
                break;
            }
            case shiftUp: {
                this.moveAllFromBudha();
                break;
            }
        }
    }

    private void moveToBudha(KObject o) {
        o.remove();
        o.setParent(this);
        this.addFirst(o);
    }

    private void moveFromBudha() {
        KObject first = this.popFirst();
        if (first == null) {
            return;
        }
        this.setPos(this.pos().plus(shiftBudha));
        first.setPos(this.pos().plus(shiftObject));
        this.parent().add(first);
        first.setParent(this.parent());
    }

    private void moveAllFromBudha() {
        KObject first = this.popFirst();
        while (first != null) {
            this.parent().add(first);
            first.setParent(this.parent());
            this.step();
            first = this.popFirst();
        }
    }

    private void moveDeepToBudha(KObject o) {
        if (!this.inside().isEmpty()) {
            o.remove();
            KObject first = this.inside().getFirst();
            o.setParent(first);
            first.addFirst(o);
            first.step();
        }
    }

    private void moveDeepFromBudha() {
        if (!this.inside().isEmpty()) {
            KObject first = this.inside().getFirst();
            KObject firstFirst = first.popFirst();
            first.step();
            if (firstFirst == null) {
                return;
            }
            this.setPos(this.pos().plus(shiftBudha));
            firstFirst.setPos(this.pos().plus(shiftObject));
            this.parent().add(firstFirst);
            firstFirst.setParent(this.parent());
        }
    }

    private void rotateInsideLeft() {
        KObject first = this.popFirst();
        if (first == null) {
            return;
        }
        this.add(first);
        this.step();
    }

    private void rotateInsideRight() {
        KObject last = this.popLast();
        if (last == null) {
            return;
        }
        this.addFirst(last);
        this.step();
    }

    protected void handleCollision(KObject o) {
        this.touched = !((Basic)o).isTakable() ? null : o;
    }
}

