/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.items.StringItem;
import kutil.kobjects.Basic;
import kutil.kobjects.Frame;

public class Button
extends Basic {
    private StringItem title;
    private StringItem cmd;
    private Int2D size;
    private static final Font idFont = new Font("SansSerif", 0, 10);
    private static final Font buttonFont = new Font("Monospaced", 0, 12);
    private static final Color bgColor = Color.white;
    private static final Color textColor = Color.blue;
    private static final Color textSelColor = new Color(85, 26, 139);

    public Button(KAtts kAtts) {
        super(kAtts);
        this.title = this.items().addString(kAtts, "title", "");
        this.cmd = this.items().addString(kAtts, "cmd", "");
        this.size = new Int2D(this.title.get().length() * 7 + 16, 20);
        this.create();
    }

    private void create() {
        this.setType("button");
        this.setMovable(false);
        this.setIsGuiStuff(true);
    }

    public void drawOutside(Graphics2D g, Int2D center, int frameDepth) {
        Int2D drawPos = center.plus(this.pos());
        g.setColor(bgColor);
        g.fillRect(drawPos.getX(), drawPos.getY(), this.size.getX(), this.size.getY());
        if (this.rucksack().showInfo()) {
            g.setFont(idFont);
            g.drawString(this.id(), drawPos.getX(), drawPos.getY() - 3);
        }
        if (this.isHighlighted()) {
            g.setColor(Color.red);
            g.drawRect(drawPos.getX(), drawPos.getY(), this.size.getX(), this.size.getY());
            g.setColor(textSelColor);
        } else {
            g.setColor(textColor);
        }
        g.setFont(buttonFont);
        g.drawString(this.title.get(), drawPos.getX() + 8, drawPos.getY() + 12);
        g.drawLine(drawPos.getX() + 8, drawPos.getY() + 15, drawPos.getX() + this.size.getX() - 10, drawPos.getY() + 15);
    }

    public boolean isHit(Int2D clickPos) {
        return Int2D.rectangeHit(clickPos, this.pos(), this.size.getX(), this.size.getY());
    }

    public void click(Int2D clickPos) {
        super.click(clickPos);
        this.rucksack().cmd(this.cmd.get());
    }

    public void drag(Int2D clickPos, Int2D delta, Frame f) {
        super.drag(clickPos, delta, f);
        this.rucksack().cmd(this.cmd.get());
    }
}

