/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import kutil.core.Global;
import kutil.core.KAtts;
import kutil.kobjects.Function;
import kutil.kobjects.KObject;
import kutil.kobjects.Num;

public class Clock
extends Function {
    private int iterations;
    private int i;
    private long lastCheck;
    private boolean isRunning = false;

    public Clock(KAtts kAtts) {
        super(kAtts);
        this.create();
    }

    public Clock(Clock s) {
        super(s);
        this.create();
    }

    public KObject copy() {
        return new Clock(this);
    }

    private void create() {
        this.setType("clock");
        this.resetVal("clock");
    }

    public void step() {
        super.step();
        if (Global.rucksack().isSimulationRunning() && this.isRunning && Clock.time() - this.lastCheck > 1000L) {
            this.lastCheck = Clock.time();
            this.handleInput(new Num(this.i), 0);
            ++this.i;
            if (this.i > this.iterations) {
                this.isRunning = false;
            }
        }
    }

    public KObject getResponse(KObject o) {
        if (this.isRunning) {
            return o;
        }
        if (o instanceof Num) {
            this.isRunning = true;
            this.lastCheck = 0L;
            this.iterations = ((Num)o).get();
            this.i = 1;
            if (this.iterations < 1) {
                this.isRunning = false;
            }
        }
        return null;
    }

    private static long time() {
        return System.currentTimeMillis();
    }
}

