/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.items.IntegerItem;
import kutil.items.StringItem;
import kutil.kobjects.Basic;
import kutil.kobjects.KObject;
import kutil.kobjects.Page;
import kutil.shapes.CommentShape;

public class Comment
extends Basic {
    private StringItem val;
    private IntegerItem actualPage;
    private Page[] pages;

    public Comment(KAtts kAtts) {
        super(kAtts);
        this.val = this.items().addString(kAtts, "val", null);
        this.actualPage = this.items().addInteger(kAtts, "actualPage", 0);
        this.create();
    }

    public Comment(String str) {
        this.val = this.items().addString("val", str);
        this.actualPage = this.items().addInteger("actualPage", 0);
        this.create();
    }

    public Comment(Comment c) {
        super(c);
        this.val = this.items().addString("val", c.val.get());
        this.actualPage = this.items().addInteger("actualPage", c.actualPage.get());
        this.create();
    }

    public KObject copy() {
        return new Comment(this);
    }

    private void create() {
        this.setType("comment");
        this.setShape(new CommentShape(this));
        this.resetVal(this.val.get());
    }

    private void resetVal(String str) {
        this.val.set(str);
        if (this.isSilent()) {
            return;
        }
        String[] ps = this.val.get().split("##");
        this.pages = new Page[ps.length];
        for (int i = 0; i < ps.length; ++i) {
            this.pages[i] = new Page(ps[i], i + 1, ps.length);
        }
    }

    public void click(Int2D clickPos) {
        super.click(clickPos);
        this.actualPage.set((this.actualPage.get() + 1) % this.pages.length);
    }

    public String line(int i) {
        return this.pages[this.actualPage.get()].line(i);
    }

    public int longestLine() {
        return this.pages[this.actualPage.get()].longestLine();
    }

    public int numLines() {
        return this.pages[this.actualPage.get()].numLines();
    }

    public boolean isSilent() {
        return this.val.get() == null;
    }
}

