/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import kutil.core.KAtts;
import kutil.items.StringItem;
import kutil.kobjects.Basic;
import kutil.kobjects.KObject;
import kutil.shapes.DirectionShape;

public class Direction
extends Basic {
    private StringItem val;
    private DirectionShape shape;

    public Direction(KAtts kAtts) {
        super(kAtts);
        this.val = this.items().addString(kAtts, "val", Vals.up.toString());
        this.create();
    }

    public Direction(Vals v) {
        this.val = this.items().addString("val", v.toString());
        this.create();
    }

    public Direction(Direction d) {
        super(d);
        this.val = this.items().addString("val", d.val.get());
        this.create();
    }

    public String toKisp() {
        return "[" + this.val.get() + "]";
    }

    public KObject copy() {
        return new Direction(this);
    }

    private void create() {
        this.setType("direction");
        this.setPhysical(true);
        this.setAttached(false);
        this.shape = new DirectionShape(this);
        this.setShape(this.shape);
    }

    public Vals get() {
        return Vals.valueOf(this.val.get());
    }

    public void set(Vals v) {
        this.val.set(v.toString());
        this.shape.resetImage();
    }

    public void rotateCW() {
        switch (Vals.valueOf(this.val.get())) {
            case up: {
                this.val.set(Vals.right.toString());
                break;
            }
            case down: {
                this.val.set(Vals.left.toString());
                break;
            }
            case left: {
                this.val.set(Vals.up.toString());
                break;
            }
            case right: {
                this.val.set(Vals.down.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Vals {
        up,
        down,
        left,
        right,
        randdir;

    }
}

