/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import ff.MotionCmd;
import ff.MotionCommander;
import ff.Sea;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.core.Log;
import kutil.functions.UnarImplementation;
import kutil.kobjects.Basic;
import kutil.kobjects.Function;
import kutil.kobjects.KObject;
import kutil.kobjects.KObjectFactory;
import org.javatuples.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FFUnit
extends Function {
    public static final int SIDE = 15;
    private Map<Character, KObject> pxToKOb;
    private Map<String, Character> oidToPx;
    private char nextPx;
    private int step;
    private int stepp;
    private MotionCommander mc;
    private List<MotionCmd> nowRunningCmds;
    private List<Pair<KObject, Character>> toAdd;
    private static final int dot1 = 3;
    private static final int dot2 = 7;
    private static final int dot3 = 12;
    private static final Int2D[] testDots = new Int2D[]{new Int2D(3, 3), new Int2D(7, 3), new Int2D(12, 3), new Int2D(3, 7), new Int2D(7, 7), new Int2D(12, 7), new Int2D(3, 12), new Int2D(7, 12), new Int2D(12, 12)};
    private static final Int2D[] deltas = new Int2D[]{new Int2D(15, 0), new Int2D(-15, 0), new Int2D(0, 15), new Int2D(0, -15), new Int2D(15, 15), new Int2D(15, -15), new Int2D(-15, 15), new Int2D(-15, -15)};

    private void create() {
        this.setType("ffunit");
        this.resetVal("ffunit");
        this.mc = new Sea(new Int2D(29, 27));
        this.nowRunningCmds = new LinkedList<MotionCmd>();
        this.pxToKOb = new HashMap<Character, KObject>();
        this.oidToPx = new HashMap<String, Character>();
        this.nextPx = (char)97;
        this.step = 0;
        this.stepp = 0;
        this.toAdd = new LinkedList<Pair<KObject, Character>>();
    }

    public void addKObject(KObject o) {
        char px;
        String ffType = ((Basic)o).getFFType();
        if ("wall".equals(ffType)) {
            px = '$';
        } else if ("small".equals(ffType)) {
            px = '~';
        } else if ("big".equals(ffType)) {
            px = '#';
        } else {
            px = this.nextPx;
            this.nextPx = (char)(this.nextPx + '\u0001');
        }
        this.pxToKOb.put(Character.valueOf(px), o);
        this.oidToPx.put(o.id(), Character.valueOf(px));
        this.toAdd.add((Pair<KObject, Character>)new Pair((Object)o, (Object)Character.valueOf(px)));
    }

    public void removeKObject(KObject o) {
        char px = this.oidToPx.get(o.id()).charValue();
        this.oidToPx.remove(o.id());
        this.pxToKOb.remove(Character.valueOf(px));
        if (px != '$') {
            this.mc.removeBlock(px);
        } else {
            this.mc.removeBlock2(FFUnit.getFFPoses(o));
        }
        Log.it(this.mc);
        LinkedList<MotionCmd> toRemove = new LinkedList<MotionCmd>();
        for (MotionCmd cmd : this.nowRunningCmds) {
            if (px != cmd.getPx()) continue;
            toRemove.add(cmd);
        }
        this.nowRunningCmds.removeAll(toRemove);
    }

    private static Set<Int2D> getFFPoses(KObject o) {
        HashSet<Int2D> poses = new HashSet<Int2D>();
        Stack<Int2D> testThem = new Stack<Int2D>();
        HashSet<Int2D> tested = new HashSet<Int2D>();
        Int2D initPos = o.pos().align(15);
        poses.add(FFUnit.toFFPos(initPos));
        tested.add(initPos);
        testThem.addAll(FFUnit.neigborPoses(initPos, tested));
        while (!testThem.isEmpty()) {
            Int2D testNow = (Int2D)testThem.pop();
            tested.add(testNow);
            if (!FFUnit.isKObjectAround(o, testNow)) continue;
            poses.add(FFUnit.toFFPos(testNow));
            testThem.addAll(FFUnit.neigborPoses(testNow, tested));
        }
        return poses;
    }

    private static boolean isKObjectAround(KObject o, Int2D pos) {
        for (Int2D testDot : testDots) {
            if (!o.isHit(pos.plus(testDot))) continue;
            return true;
        }
        return false;
    }

    private static List<Int2D> neigborPoses(Int2D pos, Set<Int2D> tested) {
        LinkedList<Int2D> ret = new LinkedList<Int2D>();
        for (Int2D delta : deltas) {
            Int2D nPos = pos.plus(delta);
            if (tested.contains(nPos)) continue;
            ret.add(nPos);
        }
        return ret;
    }

    private static Int2D toFFPos(Int2D pos) {
        return new Int2D(pos.getX() / 15, pos.getY() / 15);
    }

    @Override
    public void step() {
        super.step();
        if (Global.rucksack().isSimulationRunning()) {
            if (this.stepp % 1 == 0) {
                if (this.step % 15 == 0) {
                    for (Pair pair : this.toAdd) {
                        this.mc.addBlock(((Character)pair.getValue1()).charValue(), FFUnit.getFFPoses((KObject)pair.getValue0()));
                    }
                    this.nowRunningCmds = this.mc.getNewCmds();
                    if (!this.nowRunningCmds.isEmpty() || !this.toAdd.isEmpty()) {
                        Log.it(this.mc);
                    }
                    this.toAdd.clear();
                }
                for (MotionCmd motionCmd : this.nowRunningCmds) {
                    KObject o = this.pxToKOb.get(Character.valueOf(motionCmd.getPx()));
                    if (o == null) continue;
                    o.setPos(o.pos().plus(motionCmd.getDelta()));
                }
                ++this.step;
            }
            ++this.stepp;
        }
    }

    public FFUnit(KAtts kAtts) {
        super(kAtts);
        this.create();
    }

    public FFUnit(FFUnit u) {
        super(u);
        this.create();
    }

    @Override
    public KObject copy() {
        return new FFUnit(this);
    }

    protected KObject getResponse(KObject o) {
        this.mc.cmd(o);
        return null;
    }

    public static class FFUnitImplementation
    extends UnarImplementation {
        FFUnit ffUnit;

        public FFUnitImplementation(Function f) {
            super("ffunit", 0);
            this.ffUnit = (FFUnit)f;
        }

        public KObject compute(KObject o) {
            KObject response = this.ffUnit.getResponse(o);
            if (response == null) {
                return null;
            }
            return KObjectFactory.insertKObjectToSystem(response, null);
        }
    }
}

