/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.items.StringItem;
import kutil.kobjects.Basic;
import kutil.kobjects.FieldActor;
import kutil.kobjects.FishFilletsActor;
import kutil.kobjects.KObject;
import kutil.kobjects.LogActor;

public class Field
extends Basic {
    private StringItem action;
    private FieldActor actor;

    public Field(KAtts kAtts) {
        super(kAtts);
        this.action = this.items().addString(kAtts, "action", "log");
        this.create();
    }

    public Field(Field f) {
        super(f);
        this.action = this.items().addString("action", f.action.get());
        this.create();
    }

    private void create() {
        this.setType("field");
        this.actor = this.toActor(this.action.get());
    }

    public void init() {
        super.init();
        this.actor.init();
    }

    public void step() {
        super.step();
        this.actor.step();
    }

    public KObject copy() {
        return new Field(this);
    }

    public void reactToObjectPresence(KObject o) {
        this.actor.reactToObjectPresence(o);
    }

    public void informFieldAboutDeletation(KObject deleted) {
        this.actor.informFieldAboutDeletation(deleted);
    }

    public boolean isVisitedBy(KObject o) {
        boolean ret = this.isHit(o.pos().plus(new Int2D(1, 1)));
        return ret;
    }

    private FieldActor toActor(String action) {
        String[] parts = action.split("\\s+", 2);
        String actionName = parts[0];
        String actionParams = null;
        if (parts.length == 2) {
            actionParams = parts[1];
        }
        if ("log".equals(actionName)) {
            return new LogActor();
        }
        if ("ff".equals(actionName)) {
            return new FishFilletsActor(actionParams, this);
        }
        return new LogActor();
    }
}

