/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.kobjects.Basic;
import kutil.kobjects.FFUnit;
import kutil.kobjects.Field;
import kutil.kobjects.FieldActor;
import kutil.kobjects.KObject;

class FishFilletsActor
implements FieldActor {
    private String ffUnitId;
    private FFUnit ffUnit;
    private Field field;
    private Set<KObject> inField;
    private Map<String, Boolean> wasPhysical;

    public FishFilletsActor(String params, Field f) {
        if (params == null) {
            return;
        }
        this.ffUnitId = params;
        this.field = f;
        this.inField = new HashSet<KObject>();
        this.wasPhysical = new HashMap<String, Boolean>();
    }

    public void init() {
        this.ffUnit = (FFUnit)Global.idDB().get(this.ffUnitId);
    }

    public void informFieldAboutDeletation(KObject deleted) {
        if (!this.inField.contains(deleted)) {
            return;
        }
        this.ffUnit.removeKObject(deleted);
        if (this.wasPhysical.get(deleted.id()).booleanValue()) {
            deleted.setPhysicalOn();
        }
        this.wasPhysical.remove(deleted.id());
        this.inField.remove(deleted);
    }

    public void step() {
        LinkedList<KObject> toRemove = new LinkedList<KObject>();
        for (KObject o : this.inField) {
            if (this.field.isVisitedBy(o)) continue;
            this.ffUnit.removeKObject(o);
            toRemove.add(o);
            if (this.wasPhysical.get(o.id()).booleanValue()) {
                o.setPhysicalOn();
            }
            this.wasPhysical.remove(o.id());
        }
        this.inField.removeAll(toRemove);
    }

    public void reactToObjectPresence(KObject o) {
        if (this.ffUnit != null && !this.inField.contains(o)) {
            boolean wasPhys = o.isPhysical();
            this.inField.add(o);
            this.wasPhysical.put(o.id(), wasPhys);
            if (wasPhys) {
                o.setPhysicalOff();
                o.setPos(o.pos().align(15));
                ((Basic)o).setSpeed(Int2D.zero);
            }
            this.ffUnit.addKObject(o);
        }
    }
}

