/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import java.awt.Color;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.core.Utils;
import kutil.items.Int2DItem;
import kutil.items.ListItem;
import kutil.kobjects.Apple;
import kutil.kobjects.Basic;
import kutil.kobjects.Box;
import kutil.kobjects.Direction;
import kutil.kobjects.FlyCollisionListener;
import kutil.kobjects.Function;
import kutil.kobjects.GoalSensor;
import kutil.kobjects.KObject;
import kutil.kobjects.KObjectFactory;
import kutil.kobjects.Slot;
import kutil.kobjects.TouchSensor;
import kutil.kobjects.Wasp;
import kutil.shapes.FlyShape;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.World;

public class Fly
extends Basic {
    private Int2DItem goal;
    private ListItem mem;
    private FlyCollisionListener listener;
    private World parentWorld;
    private boolean reactionDroped;
    private Direction actualDirection;
    private Direction hitDirection;
    private Direction.Vals appleDirVal;
    private Direction.Vals waspDirVal;
    private Direction.Vals flyDirVal;
    private static final Int2D shift = new Int2D(16, 16);
    private static final Int2D childShift = new Int2D(0, 64);
    private static final double nearForGoal = 5.0;
    private static final double nearForSlot = 6.0;
    private int speed;

    public Fly(KAtts kAtts) {
        super(kAtts);
        this.goal = this.items().addInt2D(kAtts, "goal", Int2D.zero());
        this.mem = this.items().addList(kAtts, "mem");
        this.create();
    }

    public Fly() {
        this.goal = this.items().addInt2D("goal", Int2D.zero());
        this.mem = this.items().addEmptyList("mem");
        this.create();
    }

    public Fly(Fly f) {
        super(f);
        this.goal = this.items().addInt2D("goal", f.goal.get().copy());
        this.mem = this.items().addEmptyList("mem");
        for (KObject o : f.mem.get()) {
            KObject copy = o.copy();
            this.mem.get().add(copy);
        }
        this.create();
    }

    public KObject copy() {
        return new Fly(this);
    }

    private void create() {
        this.setType("fly");
        this.setPhysical(true);
        this.setAttached(false);
        this.setShape(new FlyShape(this));
        this.setIsAffectedByGravity(false);
        this.setBgcolor(new Color(80, 80, 80));
        this.reactionDroped = false;
        this.actualDirection = new Direction(Direction.Vals.right);
        this.hitDirection = null;
        this.setSpeed(60);
    }

    public void setParent(KObject newParent) {
        super.setParent(newParent);
        this.resetCollisionListener();
    }

    public void init() {
        super.init();
        for (KObject o : this.mem.get()) {
            o.init();
        }
        this.resetCollisionListener();
    }

    private void resetCollisionListener() {
        if (this.parentWorld != null) {
            this.parentWorld.removeListener(this.listener);
        }
        this.parentWorld = this.getParentWorld();
        if (this.parentWorld != null) {
            this.listener = new FlyCollisionListener(this);
            this.parentWorld.addListener(this.listener);
        }
    }

    public void step() {
        super.step();
        if (!Global.rucksack().isSimulationRunning()) {
            return;
        }
        this.resetInsideSlots();
        this.refreshSmellSensors();
        this.stepToGoal();
        if (!this.isGoalReached()) {
            this.reactionDroped = false;
        }
        if (!this.reactionDroped && this.isGoalReached()) {
            this.reactionDroped = true;
            for (KObject o : this.inside()) {
                if (!(o instanceof GoalSensor)) continue;
                GoalSensor fg = (GoalSensor)o;
                fg.fire(this.actualDirection.copy());
            }
        }
        if (this.hitDirection != null) {
            for (KObject o : this.inside()) {
                if (!(o instanceof TouchSensor)) continue;
                TouchSensor ts = (TouchSensor)o;
                ts.fire(this.hitDirection.copy());
            }
            this.hitDirection = null;
        }
    }

    private void resetInsideSlots() {
        for (KObject o : this.inside()) {
            if (!(o instanceof Function)) continue;
            Function f = (Function)o;
            f.resetSlots();
        }
    }

    private void refreshSmellSensors() {
        if (this.parent() == null) {
            return;
        }
        KObject nearestApple = null;
        KObject nearestFly = null;
        KObject nearestWasp = null;
        double minDistApple = Double.MAX_VALUE;
        double minDistFly = Double.MAX_VALUE;
        double minDistWasp = Double.MAX_VALUE;
        for (KObject o : this.parent().inside()) {
            double distance;
            if (o instanceof Apple) {
                distance = this.pos().minus(o.pos()).abs();
                if (!(distance < minDistApple)) continue;
                nearestApple = o;
                minDistApple = distance;
                continue;
            }
            if (o instanceof Wasp) {
                distance = this.pos().minus(o.pos()).abs();
                if (!(distance < minDistWasp)) continue;
                nearestWasp = o;
                minDistWasp = distance;
                continue;
            }
            if (!(o instanceof Fly) || !((distance = this.pos().minus(o.pos()).abs()) < minDistFly)) continue;
            nearestFly = o;
            minDistFly = distance;
        }
        this.appleDirVal = this.computeDirVal(nearestApple);
        this.waspDirVal = this.computeDirVal(nearestWasp);
        this.flyDirVal = this.computeDirVal(nearestFly);
    }

    private Direction.Vals computeDirVal(KObject o) {
        boolean negHalf;
        if (o == null) {
            return Direction.Vals.randdir;
        }
        Int2D relPos = o.pos().minus(this.pos());
        boolean posHalf = relPos.getX() > relPos.getY();
        boolean bl = negHalf = relPos.getX() > -relPos.getY();
        if (posHalf) {
            if (negHalf) {
                return Direction.Vals.right;
            }
            return Direction.Vals.up;
        }
        if (negHalf) {
            return Direction.Vals.down;
        }
        return Direction.Vals.left;
    }

    public KObject appleSensor() {
        Direction dir = new Direction(this.appleDirVal);
        return KObjectFactory.insertKObjectToSystem(dir, null);
    }

    public KObject waspSensor() {
        Direction dir = new Direction(this.waspDirVal);
        return KObjectFactory.insertKObjectToSystem(dir, null);
    }

    public KObject flySensor() {
        Direction dir = new Direction(this.flyDirVal);
        return KObjectFactory.insertKObjectToSystem(dir, null);
    }

    public String memString() {
        StringBuilder sb = new StringBuilder();
        sb.append("( ");
        for (KObject o : this.mem.get()) {
            sb.append(o.toKisp());
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    public void flyCmd(KObject o) {
        if (o instanceof Direction) {
            this.actualDirection = (Direction)o;
            switch (this.actualDirection.get()) {
                case up: {
                    this.moveGoal(0, -1);
                    break;
                }
                case down: {
                    this.moveGoal(0, 1);
                    break;
                }
                case left: {
                    this.moveGoal(-1, 0);
                    break;
                }
                case right: {
                    this.moveGoal(1, 0);
                    break;
                }
                case randdir: {
                    int x = Global.random().nextInt(3) - 1;
                    int y = Global.random().nextInt(3) - 1;
                    this.moveGoal(x, y);
                }
            }
            this.reactionDroped = false;
        }
    }

    public KObject getMem() {
        Box box = new Box();
        KObjectFactory.insertKObjectToSystem(box, null);
        for (KObject o : this.mem.get()) {
            KObject copy = KObjectFactory.insertKObjectToSystem(o.copy(), null);
            box.add(copy);
        }
        box.step();
        return box;
    }

    public KObject topMem() {
        if (this.mem.get().isEmpty()) {
            return null;
        }
        return KObjectFactory.insertKObjectToSystem(this.mem.get().getFirst().copy(), null);
    }

    public KObject popMem() {
        if (this.mem.get().isEmpty()) {
            return null;
        }
        return this.mem.get().pop();
    }

    public void pushMem(KObject vzor) {
        if (vzor == null) {
            return;
        }
        this.mem.get().push(KObjectFactory.insertKObjectToSystem(vzor.copy(), null));
    }

    public KObject getDataFromActualPosition() {
        if (this.parent() == null || !(this.parent() instanceof Basic)) {
            return null;
        }
        Basic parent = (Basic)this.parent();
        for (KObject o : parent.inside()) {
            Slot slot;
            if (!(o instanceof Slot) || !this.isNear((slot = (Slot)o).pos(), this.pos(), 6.0)) continue;
            if (slot.inside().isEmpty()) {
                return null;
            }
            KObject ret = slot.inside().getFirst().copy();
            return KObjectFactory.insertKObjectToSystem(ret, null);
        }
        return KObjectFactory.insertKObjectToSystem(new Box(), null);
    }

    public void setDataForActualPosition(KObject vzor) {
        if (this.parent() == null || !(this.parent() instanceof Basic)) {
            return;
        }
        Basic parent = (Basic)this.parent();
        for (KObject o : parent.inside()) {
            Slot slot;
            if (!(o instanceof Slot) || !this.isNear((slot = (Slot)o).pos(), this.pos(), 6.0)) continue;
            slot.directClear();
            KObject copy = vzor.copy();
            slot.directAdd(copy);
            KObjectFactory.insertKObjectToSystem(copy, slot);
            return;
        }
        Slot newSlot = (Slot)KObjectFactory.insertKObjectToSystem(new Slot(), parent);
        parent.addFirst(newSlot);
        int posX = (int)Math.floor((double)this.pos().getX() / 32.0) * 32 + 16;
        int posY = (int)Math.floor((double)this.pos().getY() / 32.0) * 32 + 16;
        newSlot.setPos(new Int2D(posX, posY));
        KObject copy = vzor.copy();
        newSlot.directAdd(copy);
        KObjectFactory.insertKObjectToSystem(copy, newSlot);
    }

    private void moveGoal(int x, int y) {
        this.goal.set(this.goal.get().plus(new Int2D(x, y)));
    }

    public Direction getActualDirection() {
        return this.actualDirection;
    }

    public Int2D goalPos() {
        return this.goal.get().times(32.0).plus(shift);
    }

    private boolean isGoalReached() {
        return this.isNear(this.goalPos(), this.pos(), 5.0);
    }

    private boolean isNear(Int2D pos1, Int2D pos2, double r) {
        return pos1.minus(pos2).abs() < r;
    }

    private void stepToGoal() {
        Vector2f v = Int2D.toROVector2f(this.goalPos());
        Body body = this.getBody();
        v.sub(body.getPosition());
        v.normalise();
        v.scale(this.speed);
        Utils.stopBody(body);
        body.adjustVelocity(v);
    }

    public void setSpeed(int s) {
        this.speed = s;
    }

    protected void handleCollision(Int2D hitPos, KObject hitObject) {
        Int2D relHitPos = hitPos.minus(this.pos());
        int x = relHitPos.getX();
        int y = relHitPos.getY();
        if (y < -8) {
            this.hitDirection = new Direction(Direction.Vals.up);
        } else if (y > 8) {
            this.hitDirection = new Direction(Direction.Vals.down);
        } else if (x < -8) {
            this.hitDirection = new Direction(Direction.Vals.left);
        } else if (x > 8) {
            this.hitDirection = new Direction(Direction.Vals.right);
        }
        if (hitObject instanceof Apple && !(this instanceof Wasp)) {
            hitObject.delete();
            KObject child = this.copy();
            KObjectFactory.insertKObjectToSystem(child, null);
            child.setParent(this.parent());
            this.parent().add(child);
            child.setPos(this.pos().plus(childShift));
        }
    }
}

