/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.items.BooleanItem;
import kutil.items.Int2DItem;
import kutil.items.StringItem;
import kutil.kevents.ClickEvent;
import kutil.kevents.DragEvent;
import kutil.kevents.KEvent;
import kutil.kevents.ReleaseEvent;
import kutil.kobjects.Basic;
import kutil.kobjects.KObject;
import kutil.kobjects.MyJFrame;
import kutil.kobjects.Time;

public class Frame
extends Basic {
    private static final int maxFrameDepth = 100;
    private Int2DItem size;
    private Int2DItem cam;
    private StringItem targetID;
    private StringItem title;
    private BooleanItem showXML;
    private BooleanItem movableCam;
    private KObject target;
    private Int2D center;
    private boolean jFrameZatimNezalozen;
    private boolean isHighlightedFrame;
    private MyJFrame myJFrame;
    private int steps = 0;
    private Int2D camBefore;
    private Color decorColor = new Color(166, 192, 229);
    private Color backgroundColor = Color.white;
    private boolean showZeroPoint = true;
    private static final Font decorFont = new Font("SansSerif", 1, 11);
    private static final Font xmlFont = new Font("SansSerif", 0, 10);
    private static final int posunFont = 4;
    private static final int decorY = 20;
    private static final Color highlightColor = Color.red;
    private static final Color highlightFrameColor = Color.green;
    private static final Int2D decorDelta = new Int2D(0, 20);
    private static final Font idFont = new Font("SansSerif", 0, 10);
    private static final Color zeroPointColor = Color.black;

    public Frame(KAtts kAtts) {
        super(kAtts);
        this.setType("frame");
        this.size = this.items().addInt2D(kAtts, "size", new Int2D(600, 600));
        this.cam = this.items().addInt2D(kAtts, "cam", Int2D.zero());
        this.targetID = this.items().addString(kAtts, "target", null);
        this.title = this.items().addString(kAtts, "title", this.targetID.get());
        this.showXML = this.items().addBoolean(kAtts, "showXML", false);
        this.movableCam = this.items().addBoolean(kAtts, "movableCam", true);
        this.computeCenter();
        this.jFrameZatimNezalozen = true;
        this.isHighlightedFrame = false;
    }

    public void init() {
        super.init();
        if (this.targetID.get() == null) {
            this.target = this;
            if (this.title.get() == null) {
                this.title.set(this.id());
            }
        } else {
            this.target = this.idDB().get(this.targetID.get());
        }
        this.backgroundColor = this.showXML.get() ? Color.BLACK : this.target.bgcolor();
    }

    public void step() {
        super.step();
        ++this.steps;
        if (!this.showXML.get()) {
            this.backgroundColor = this.target.bgcolor();
        }
        if (!(this.parent() instanceof Time)) {
            return;
        }
        if (this.jFrameZatimNezalozen) {
            this.myJFrame = new MyJFrame(this);
            this.jFrameZatimNezalozen = false;
            this.rucksack().setSelected(this);
            this.rucksack().setSelectedFrame(this);
        }
        this.myJFrame.myJPanel.paintScreen();
    }

    public void resetTarget(String newTargetID) {
        this.target = this.idDB().get(newTargetID);
        this.targetID.set(newTargetID);
        this.title.set(this.targetID.get());
        if (!this.jFrameZatimNezalozen) {
            this.myJFrame.setTitle(this.title.get());
        }
        this.backgroundColor = this.target.bgcolor();
    }

    public void resolveRenaming(String oldId, String newId) {
        super.resolveRenaming(oldId, newId);
        if (this.targetID.get() != null && this.targetID.get().equals(oldId)) {
            this.resetTarget(newId);
        }
    }

    public KObject getTarget() {
        return this.target;
    }

    public void resetSize(int x, int y) {
        this.size.get().setX(x);
        this.size.get().setY(y);
        this.computeCenter();
    }

    private void computeCenter() {
        this.center = this.cam.get().negate();
    }

    public Int2D getCenter() {
        return this.center;
    }

    public void setHighlightedFrame(boolean isHighlightedFrame) {
        this.isHighlightedFrame = isHighlightedFrame;
    }

    public void setDecorColor(Color c) {
        this.decorColor = c;
    }

    public void setShowZeroPoint(boolean b) {
        this.showZeroPoint = b;
    }

    public void toggleShowXML() {
        this.showXML.set(!this.showXML.get());
        if (this.showXML.get()) {
            this.camBefore = this.cam.get();
            this.backgroundColor = Color.BLACK;
        } else {
            this.backgroundColor = this.target.bgcolor();
        }
        this.cam.set(this.showXML.get() ? Int2D.zero() : this.camBefore);
        this.computeCenter();
    }

    public void drawOutside(Graphics2D g, Int2D c, int frameDepth) {
        Shape initClip = g.getClip();
        Int2D drawPos = c.plus(this.pos());
        this.drawBackground(g, drawPos);
        this.setFrameClip(g, drawPos);
        this.drawFrame(g, drawPos.plus(this.center).plus(decorDelta), drawPos.plus(decorDelta), frameDepth + 1);
        g.setClip(initClip);
        this.drawDecorFrame(g, drawPos);
        if (this.rucksack().showInfo()) {
            g.setColor(this.decorColor);
            g.setFont(idFont);
            g.drawString(this.id(), drawPos.getX(), drawPos.getY() - 3);
        }
        if (this.isHighlighted()) {
            g.setColor(highlightColor);
            g.drawRect(drawPos.getX(), drawPos.getY(), this.size.get().getX(), this.size.get().getY() + 20);
        }
        if (this.isHighlightedFrame) {
            g.setColor(highlightFrameColor);
            g.drawRect(drawPos.getX() - 1, drawPos.getY() - 1, this.size.get().getX() + 2, this.size.get().getY() + 20 + 2);
        }
    }

    private void setFrameClip(Graphics2D g, Int2D drawPos) {
        Rectangle clip = g.getClipBounds();
        int clipX1 = drawPos.getX();
        int clipY1 = drawPos.getY();
        int clipX2 = drawPos.getX() + this.size.get().getX();
        int clipY2 = drawPos.getY() + this.size.get().getY();
        if ((double)clipX1 < clip.getX()) {
            clipX1 = (int)clip.getX();
        }
        if ((double)clipY1 < clip.getY()) {
            clipY1 = (int)clip.getY();
        }
        if ((double)clipX2 < clip.getX()) {
            clipX2 = (int)clip.getX();
        }
        if ((double)clipY2 < clip.getY()) {
            clipY2 = (int)clip.getY();
        }
        if ((double)clipX1 > clip.getX() + clip.getWidth()) {
            clipX1 = (int)(clip.getX() + clip.getWidth());
        }
        if ((double)clipY1 > clip.getY() + clip.getHeight() - 20.0) {
            clipY1 = (int)(clip.getY() + clip.getHeight() - 20.0);
        }
        if ((double)clipX2 > clip.getX() + clip.getWidth()) {
            clipX2 = (int)(clip.getX() + clip.getWidth());
        }
        if ((double)clipY2 > clip.getY() + clip.getHeight() - 20.0) {
            clipY2 = (int)(clip.getY() + clip.getHeight() - 20.0);
        }
        g.setClip(clipX1, clipY1, clipX2 - clipX1, clipY2 - clipY1 + 20);
    }

    private void drawBackground(Graphics2D g, Int2D drawPos) {
        g.setColor(this.backgroundColor);
        g.fillRect(drawPos.getX(), drawPos.getY() + 20, this.size.get().getX(), this.size.get().getY());
    }

    private void drawDecorFrame(Graphics2D g, Int2D drawPos) {
        g.setColor(this.decorColor);
        g.drawRect(drawPos.getX(), drawPos.getY() + 20, this.size.get().getX(), this.size.get().getY());
        g.fillRect(drawPos.getX(), drawPos.getY(), this.size.get().getX() + 1, 21);
        g.setColor(Color.white);
        g.setFont(decorFont);
        g.drawString(this.title.get(), drawPos.getX() + 3 + 4, drawPos.getY() + 20 - 1 - 4);
    }

    private void drawFrame(Graphics2D g, Int2D c, Int2D corner, int frameDept) {
        this.drawProgressBar(g, corner);
        if (this.showXML.get()) {
            g.setColor(Color.green);
            g.setFont(xmlFont);
            String[] rows = this.target.toXml().toString().split("\n");
            for (int i = 0; i < rows.length; ++i) {
                g.drawString(rows[i], c.getX() + 4, c.getY() + 11 * (i + 1));
            }
        } else if (frameDept < 100) {
            this.drawBackground(g, corner.minus(decorDelta));
            if (this.showZeroPoint) {
                this.drawZeroPoint(g, c);
            }
            this.target.drawInside(g, c, frameDept);
        }
        if (!this.jFrameZatimNezalozen) {
            g.setColor(Color.black);
            if (this.isHighlighted()) {
                g.setColor(highlightColor);
                g.drawRect(0, 0, this.size.get().getX() - 1, this.size.get().getY() - 1);
            }
            if (this.rucksack().showInfo()) {
                g.setFont(idFont);
                g.drawString(this.id(), 3, 12);
            }
            if (this.isHighlightedFrame) {
                g.setColor(highlightFrameColor);
                g.drawRect(1, 1, this.size.get().getX() - 3, this.size.get().getY() - 3);
            }
        }
    }

    private void drawZeroPoint(Graphics2D g, Int2D c) {
        g.setColor(zeroPointColor);
        g.drawLine(c.getX() - 10, c.getY(), c.getX() + 10, c.getY());
        g.drawLine(c.getX(), c.getY() - 10, c.getX(), c.getY() + 10);
    }

    private void drawProgressBar(Graphics2D g, Int2D corner) {
        g.setColor(Color.green);
        g.fillRect(corner.getX(), corner.getY() + this.size.get().getY() - 1, this.steps % this.size.get().getX(), 1);
    }

    private void frameEvent(KEvent kEvent) {
        this.target.event(kEvent);
    }

    public boolean isHit(Int2D clickPos) {
        return Int2D.rectangeHit(clickPos, this.pos(), this.size.get().getX(), this.size.get().getY() + 20);
    }

    public void drag(Int2D clickPos, Int2D delta, Frame f) {
        if (this.isDecorHit(clickPos)) {
            super.drag(clickPos, delta, f);
            if (!this.jFrameZatimNezalozen) {
                this.myJFrame.setLocation(this.pos().getX(), this.pos().getY());
            }
        } else if (this.showXML.get()) {
            this.moveCam(delta);
        } else {
            this.frameEvent(new DragEvent(clickPos.minus(this.pos().plus(decorDelta)).minus(this.center), delta, this));
        }
    }

    public void click(Int2D clickPos) {
        if (this.showXML.get() || this.isDecorHit(clickPos)) {
            super.click(clickPos);
        } else {
            this.frameEvent(new ClickEvent(clickPos.minus(this.pos().plus(decorDelta)).minus(this.center), this));
        }
    }

    public boolean isDecorHit(Int2D clickPos) {
        return clickPos.minus(this.pos()).getY() < 20;
    }

    public void release(Int2D clickPos, KObject obj) {
        this.frameEvent(new ReleaseEvent(clickPos.minus(this.pos().plus(decorDelta)).minus(this.center)));
    }

    public void moveCam(Int2D delta) {
        if (this.movableCam.get()) {
            this.cam.set(this.cam.get().minus(delta));
            this.computeCenter();
        }
    }

    public void setCam(Int2D pos) {
        if (this.movableCam.get()) {
            this.cam.set(pos);
            this.computeCenter();
        }
    }

    public String getTitle() {
        return this.title.get();
    }

    public Int2D getSize() {
        return this.size.get();
    }

    public JPanel getJPanel() {
        return this.myJFrame.myJPanel;
    }

    protected void paintScreen(Graphics2D g) {
        this.drawFrame(g, this.center, Int2D.zero, 0);
    }

    protected void mouseClicked(MouseEvent e) {
        this.frameEvent(new ClickEvent(this.clickPos(e), this));
        this.rucksack().onClick(e);
        if (e.getButton() == 3) {
            Global.rucksack().clickedRightMouseButton(this, e.getX(), e.getY());
        }
    }

    protected void mousePressed(MouseEvent e) {
    }

    protected void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            return;
        }
        this.frameEvent(new ReleaseEvent(this.clickPos(e)));
    }

    protected void mouseDragged(MouseEvent e, Int2D delta) {
        this.frameEvent(new DragEvent(this.clickPos(e), delta, this));
        this.rucksack().onDrag(e);
        this.rucksack().onMove(e);
        if (e.getButton() == 3) {
            Global.rucksack().clickedRightMouseButton(this, e.getX(), e.getY());
        }
    }

    protected void mouseMoved(MouseEvent e) {
        this.rucksack().onMove(e);
    }

    private Int2D clickPos(MouseEvent e) {
        return new Int2D(e.getX(), e.getY()).minus(this.center);
    }

    public void glueBricks() {
        if (this.getTarget() == null) {
            return;
        }
        if (!this.getTarget().inside().isEmpty()) {
            this.getTarget().inside().getFirst().getBasic().glueBricks();
        }
    }
}

