/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import kutil.core.Global;
import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.functions.BinarImplementation;
import kutil.functions.Call;
import kutil.functions.Eval;
import kutil.functions.FunctionImplemetation;
import kutil.functions.Kisp;
import kutil.functions.Lambda;
import kutil.functions.NularImplementation;
import kutil.functions.TernarImplementation;
import kutil.functions.UnarBinarImplementation;
import kutil.functions.UnarCall;
import kutil.functions.UnarEval;
import kutil.functions.UnarImplementation;
import kutil.functions.UnarNularImplementation;
import kutil.items.StringItem;
import kutil.kobjects.Basic;
import kutil.kobjects.Frame;
import kutil.kobjects.In;
import kutil.kobjects.Inputable;
import kutil.kobjects.KObject;
import kutil.kobjects.KObjectFactory;
import kutil.kobjects.Out;
import kutil.kobjects.Outputable;
import kutil.kobjects.Recursion;
import kutil.kobjects.Symbol;
import kutil.shapes.BinarShape;
import kutil.shapes.FunctionShape;
import kutil.shapes.NularShape;
import kutil.shapes.TernarShape;
import kutil.shapes.UnarBinarShape;
import kutil.shapes.UnarNularShape;
import kutil.shapes.UnarShape;

public class Function
extends Basic
implements Inputable,
Outputable {
    private StringItem targetString;
    private StringItem insideTargetString;
    private StringItem outsideTargetString;
    private StringItem val;
    private FType fType;
    private Inputable[] targets;
    private int[] targetPorts;
    private Inputable[] insideTargets;
    private int[] insideTargetPorts;
    private Inputable[] outsideTargets;
    private int[] outsideTargetPorts;
    private FunctionImplemetation implementation;
    private KObject[] slots;
    private int numFreeSlots;
    private boolean isUserDefined;
    private static final Int2D arrowEndUnar = new Int2D(16, -1);
    private static final Int2D[] arrowEndsBinar = new Int2D[]{new Int2D(16, -1), new Int2D(49, -1)};
    private static final Int2D[] arrowEndsTernar = new Int2D[]{new Int2D(16, -1), new Int2D(49, -1), new Int2D(82, -1)};
    private static final Int2D arrowEndUB = new Int2D(33, -1);
    private boolean isCalledByCall = false;
    private KObject[] haxCallRet = null;
    private static int inXUnar = 0;
    private static int inXUnarBinar = 17;
    private static int[] inXBinar = new int[]{-10, 43};
    private static int[] inXTernar = new int[]{-10, 33, 76};
    private static int outXTernar = 33;

    public Function(KAtts kAtts) {
        super(kAtts);
        this.targetString = this.items().addString(kAtts, "target", null);
        this.insideTargetString = this.items().addString(kAtts, "insideTarget", null);
        this.outsideTargetString = this.items().addString(kAtts, "outsideTarget", null);
        this.val = this.items().addString(kAtts, "val", null);
        this.create();
    }

    public Function(String value) {
        this.targetString = this.items().addString("target", null);
        this.insideTargetString = this.items().addString("insideTarget", null);
        this.outsideTargetString = this.items().addString("outsideTarget", null);
        this.val = this.items().addString("val", value);
        this.create();
    }

    public Function(Function f) {
        super(f);
        this.targetString = this.items().addString("target", f.targetString.get());
        this.insideTargetString = this.items().addString("insideTarget", f.insideTargetString.get());
        this.outsideTargetString = this.items().addString("outsideTarget", f.outsideTargetString.get());
        this.val = this.items().addString("val", f.val.get());
        this.create();
    }

    public KObject copy() {
        return new Function(this);
    }

    private void create() {
        this.setType("function");
        this.resolveImplementation();
    }

    public String toKisp() {
        if (this instanceof Recursion) {
            return "recursion";
        }
        if (this.isUserDefined) {
            return super.toKisp();
        }
        return this.val.get();
    }

    private void resolveImplementation() {
        this.isUserDefined = !this.inside().isEmpty() && this.val.get() == null;
        this.implementation = Kisp.newImplementation(this.val.get(), this);
        if (this.implementation instanceof Lambda) {
            switch (this.implementation.numArgs()) {
                case 1: {
                    this.fType = FType.unar;
                    break;
                }
                case 2: {
                    this.fType = FType.binar;
                    break;
                }
                case 3: {
                    this.fType = FType.ternar;
                    break;
                }
                default: {
                    this.fType = FType.other;
                    break;
                }
            }
        } else {
            this.fType = this.implementation instanceof UnarImplementation ? FType.unar : (this.implementation instanceof BinarImplementation ? FType.binar : (this.implementation instanceof TernarImplementation ? FType.ternar : (this.implementation instanceof UnarBinarImplementation ? FType.unarBinar : (this.implementation instanceof NularImplementation ? FType.nular : (this.implementation instanceof UnarNularImplementation ? FType.unarNular : FType.other)))));
        }
        this.resetSlots();
        switch (this.fType) {
            case unar: {
                this.setShape(new UnarShape(this, this.isUserDefined));
                break;
            }
            case binar: {
                this.setShape(new BinarShape(this));
                break;
            }
            case ternar: {
                this.setShape(new TernarShape(this));
                break;
            }
            case unarBinar: {
                this.setShape(new UnarBinarShape(this));
                break;
            }
            case nular: {
                this.setShape(new NularShape(this));
                break;
            }
            case unarNular: {
                this.setShape(new UnarNularShape(this));
                break;
            }
            default: {
                this.setShape(new FunctionShape(this));
            }
        }
    }

    public void resetVal(String str) {
        this.val.set(str);
        this.resolveImplementation();
    }

    public void init() {
        super.init();
        this.resetTargets();
        this.resetInsideTargets();
        this.resetOutsideTargets();
    }

    public void resolveRenaming(String oldId, String newId) {
        super.resolveRenaming(oldId, newId);
        this.targetString.set(Function.repairTarget(oldId, newId, this.targetString.get()));
        this.resetTargets();
        this.insideTargetString.set(Function.repairTarget(oldId, newId, this.insideTargetString.get()));
        this.resetInsideTargets();
        this.outsideTargetString.set(Function.repairTarget(oldId, newId, this.outsideTargetString.get()));
        this.resetOutsideTargets();
    }

    public static String repairTarget(String oldId, String newId, String targetStr) {
        if (targetStr == null) {
            return null;
        }
        if (targetStr.equals("")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] ts = targetStr.split(" ");
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i].equals("null")) {
                sb.append("null");
            } else {
                String[] part = ts[i].split(":");
                if (part[0].equals(oldId)) {
                    sb.append(newId);
                } else {
                    sb.append(part[0]);
                }
                sb.append(":");
                sb.append(part[1]);
            }
            if (i == ts.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public void resolveCopying() {
        super.resolveCopying();
        if (this.isCopied()) {
            String newTargetString = Global.idChangeDB().repairTargetString(this.targetString.get());
            this.targetString.set(newTargetString);
            this.resetTargets();
            String newInsideTargetString = Global.idChangeDB().repairTargetString(this.insideTargetString.get());
            this.insideTargetString.set(newInsideTargetString);
            this.resetInsideTargets();
            String newOutsideTargetString = Global.idChangeDB().repairTargetString(this.outsideTargetString.get());
            this.outsideTargetString.set(newOutsideTargetString);
            this.resetOutsideTargets();
        }
    }

    private void resetTargets() {
        if (this.targetString.get() == null) {
            this.targets = new Inputable[0];
            this.targetPorts = new int[0];
            return;
        }
        String[] ts = this.targetString.get().split(" ");
        this.targets = new Inputable[ts.length];
        this.targetPorts = new int[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i].equals("null")) {
                this.targets[i] = null;
                this.targetPorts[i] = -1;
            }
            String[] parts = ts[i].split(":");
            KObject o = this.idDB().get(parts[0]);
            if (!(o instanceof Inputable)) continue;
            this.targets[i] = (Inputable)((Object)o);
            this.targetPorts[i] = Integer.parseInt(parts[1]);
        }
    }

    private void resetInsideTargets() {
        if (this.insideTargetString.get() == null) {
            this.insideTargets = new Inputable[0];
            this.insideTargetPorts = new int[0];
            return;
        }
        String[] ts = this.insideTargetString.get().split(" ");
        this.insideTargets = new Inputable[ts.length];
        this.insideTargetPorts = new int[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i].equals("null")) {
                this.insideTargets[i] = null;
                this.insideTargetPorts[i] = -1;
            }
            String[] parts = ts[i].split(":");
            KObject o = this.idDB().get(parts[0]);
            if (!(o instanceof Inputable)) continue;
            this.insideTargets[i] = (Inputable)((Object)o);
            this.insideTargetPorts[i] = Integer.parseInt(parts[1]);
        }
    }

    private void resetOutsideTargets() {
        if (this.outsideTargetString.get() == null) {
            this.outsideTargets = new Inputable[0];
            this.outsideTargetPorts = new int[0];
            return;
        }
        String[] ts = this.outsideTargetString.get().split(" ");
        this.outsideTargets = new Inputable[ts.length];
        this.outsideTargetPorts = new int[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i].equals("null")) {
                this.outsideTargets[i] = null;
                this.outsideTargetPorts[i] = -1;
            }
            String[] parts = ts[i].split(":");
            KObject o = this.idDB().get(parts[0]);
            if (!(o instanceof Inputable)) continue;
            this.outsideTargets[i] = (Inputable)((Object)o);
            this.outsideTargetPorts[i] = Integer.parseInt(parts[1]);
        }
    }

    public void changeTargets(String str) {
        this.targetString.set(str);
        this.resetTargets();
    }

    public void changeInsideTargets(String str) {
        this.insideTargetString.set(str);
        this.resetInsideTargets();
    }

    public void changeOutsideTargets(String str) {
        this.outsideTargetString.set(str);
        this.resetOutsideTargets();
    }

    public void setTargetAndPort(int fromPort, Inputable t, int p) {
        int i;
        String[] ts = this.targetString.get() != null ? this.targetString.get().split(" ") : new String[]{};
        if (ts.length <= fromPort) {
            String[] ts2 = new String[fromPort + 1];
            System.arraycopy(ts, 0, ts2, 0, ts.length);
            for (i = ts.length; i < ts2.length; ++i) {
                ts2[i] = "null";
            }
            ts = ts2;
        }
        ts[fromPort] = t != null ? t.id() + ":" + p : "null";
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < ts.length; ++i) {
            sb.append(ts[i]);
            if (i == ts.length - 1) continue;
            sb.append(" ");
        }
        this.targetString.set(sb.toString());
        this.resetTargets();
    }

    public void resetSlots() {
        this.numFreeSlots = this.implementation.numArgs();
        this.slots = new KObject[this.numFreeSlots];
    }

    public KObject[] call(KObject[] inputs) {
        this.isCalledByCall = true;
        this.doBeforeComputation();
        if (this.implementation instanceof Call) {
            this.call_before(inputs[0], inputs[1]);
        } else if (this.implementation instanceof UnarCall) {
            this.call_before(((UnarCall)this.implementation).getArg(), inputs[0]);
        }
        if (this.insideTargetString.get() == null) {
            KObject[] ret = null;
            if (this.implementation instanceof Eval) {
                FunctionImplemetation fi = Kisp.newImplementation(inputs[0].toKisp(), this);
                ret = fi.compute(new KObject[]{inputs[1]});
            } else if (this.implementation instanceof UnarEval) {
                FunctionImplemetation fi = Kisp.newImplementation(((UnarEval)this.implementation).getArg().toKisp(), this);
                ret = fi.compute(new KObject[]{inputs[0]});
            } else {
                ret = this.implementation.compute(inputs);
            }
            this.isCalledByCall = false;
            return ret;
        }
        this.haxCallRet = new KObject[this.implementation.numOutputs()];
        if (this.implementation instanceof Call) {
            this.insideTargets[0].handleInput(inputs[1], this.insideTargetPorts[0]);
        } else if (this.implementation instanceof UnarCall) {
            this.insideTargets[0].handleInput(inputs[0], this.insideTargetPorts[0]);
        } else {
            for (int i = 0; i < this.insideTargets.length && i < inputs.length; ++i) {
                if (this.insideTargets[i] == null) continue;
                this.insideTargets[i].handleInput(inputs[i], this.insideTargetPorts[i]);
            }
        }
        this.isCalledByCall = false;
        return this.haxCallRet;
    }

    public void handleInput(KObject input, int port) {
        if (input == null) {
            return;
        }
        if (this.slots.length > 0) {
            if (this.slots[port] == null) {
                --this.numFreeSlots;
            }
            this.slots[port] = input;
            if (this.numFreeSlots > 0) {
                return;
            }
        }
        this.doBeforeComputation();
        if (this.implementation instanceof Call) {
            this.call_before(this.slots[0], this.slots[1]);
        } else if (this.implementation instanceof UnarCall) {
            this.call_before(((UnarCall)this.implementation).getArg(), this.slots[0]);
        }
        if (this.insideTargetString.get() == null) {
            FunctionImplemetation fi;
            KObject[] ret = null;
            if (this.implementation instanceof Eval) {
                fi = Kisp.newImplementation(this.slots[0].toKisp(), this);
                ret = fi.compute(new KObject[]{this.slots[1]});
            } else if (this.implementation instanceof UnarEval) {
                fi = Kisp.newImplementation(((UnarEval)this.implementation).getArg().toKisp(), this);
                ret = fi.compute(new KObject[]{this.slots[0]});
            } else {
                ret = this.implementation.compute(this.slots);
            }
            if (this.outsideTargetString.get() == null) {
                for (int i = 0; i < this.targets.length; ++i) {
                    if (this.targets[i] == null) continue;
                    this.targets[i].handleInput(ret[i], this.targetPorts[i]);
                }
                this.resetSlots();
            } else {
                for (int i = 0; i < this.outsideTargets.length; ++i) {
                    if (this.outsideTargets[i] == null) continue;
                    this.outsideTargets[i].handleOutsideInput(ret[i], this.outsideTargetPorts[i]);
                }
                this.resetSlots();
            }
        } else {
            if (this.implementation instanceof Call) {
                this.insideTargets[0].handleInput(this.slots[1], this.insideTargetPorts[0]);
            } else if (this.implementation instanceof UnarCall) {
                this.insideTargets[0].handleInput(this.slots[0], this.insideTargetPorts[0]);
            } else {
                for (int i = 0; i < this.insideTargets.length && i < this.slots.length; ++i) {
                    if (this.insideTargets[i] == null) continue;
                    this.insideTargets[i].handleInput(this.slots[i], this.insideTargetPorts[i]);
                }
            }
            this.resetSlots();
        }
    }

    private void call_before(KObject name, KObject input) {
        if (name instanceof Symbol) {
            Symbol id = (Symbol)name;
            KObject o = Global.idDB().get(id.get());
            if (o != null && o instanceof Function) {
                Function f = (Function)o.copy();
                KObjectFactory.insertKObjectToSystem(f, this);
                this.add(f);
                f.setPos(new Int2D(200, 200));
                this.changeInsideTargets(f.id() + ":0");
                f.changeOutsideTargets(this.id() + ":0");
                f.changeTargets(null);
            }
        }
    }

    private void call_after() {
        this.changeInsideTargets(null);
        this.clearAfterAdding();
    }

    public Inputable[] getInsideTargets() {
        return this.insideTargets;
    }

    public void doBeforeComputation() {
    }

    public void doAfterComputation() {
    }

    public void handleOutsideInput(KObject input, int port) {
        if (this.isCalledByCall) {
            this.hax_handleOutsideInput(input, port);
            return;
        }
        if (this.outsideTargetString.get() == null) {
            if (this.targets[port] != null) {
                this.targets[port].handleInput(input, this.targetPorts[port]);
            }
        } else if (this.outsideTargets[port] != null) {
            this.outsideTargets[port].handleOutsideInput(input, this.outsideTargetPorts[port]);
        }
        this.doAfterComputation();
        if (this.implementation instanceof Call || this.implementation instanceof UnarCall) {
            this.call_after();
        }
    }

    private void hax_handleOutsideInput(KObject input, int port) {
        this.haxCallRet[port] = input;
        this.doAfterComputation();
        if (this.implementation instanceof Call || this.implementation instanceof UnarCall) {
            this.call_after();
        }
    }

    public int getNumTargets() {
        return this.targets.length;
    }

    public FunctionImplemetation getImplementation() {
        return this.implementation;
    }

    public boolean doDrawArrow(int i) {
        if (this.targets.length <= i) {
            return false;
        }
        if (this.targets[i] == null) {
            return false;
        }
        return this.targets[i].parent() == this.parent();
    }

    public Int2D getTargetArrowEnd(int i) {
        if (this.targets == null) {
            return this.pos();
        }
        return this.targets[i].getArrowEnd(this.targetPorts[i]);
    }

    public void addInAndOut() {
        KObject p = this.parent();
        if (p instanceof Basic) {
            int i;
            Basic parent = (Basic)p;
            for (i = 0; i < this.implementation.numArgs(); ++i) {
                In in = new In();
                KObjectFactory.insertKObjectToSystem(in, parent);
                parent.add(in);
                in.setPos(this.pos().plus(new Int2D(this.inX(i), -50)));
                in.setTargetAndPort(0, this, i);
            }
            for (i = 0; i < this.implementation.numOutputs(); ++i) {
                if (this.targets.length > i && this.targets[i] != null) continue;
                Out out = new Out();
                KObjectFactory.insertKObjectToSystem(out, parent);
                parent.add(out);
                out.setPos(this.pos().plus(new Int2D(this.outX(i), 80)));
                this.setTargetAndPort(i, out, 0);
            }
        }
    }

    private int inX(int i) {
        switch (this.fType) {
            case unar: {
                return inXUnar;
            }
            case binar: {
                return inXBinar[i];
            }
            case ternar: {
                return inXTernar[i];
            }
            case unarBinar: {
                return inXUnarBinar;
            }
            case unarNular: {
                return inXUnar;
            }
        }
        return i * 40;
    }

    private int outX(int i) {
        switch (this.fType) {
            case unar: {
                return inXUnar;
            }
            case binar: {
                return inXUnarBinar;
            }
            case ternar: {
                return outXTernar;
            }
            case unarBinar: {
                return inXBinar[i];
            }
            case nular: {
                return inXUnar;
            }
        }
        return i * 40;
    }

    public void click(Int2D clickPos) {
        switch (this.fType) {
            case unar: {
                this.clickUnar(clickPos);
                break;
            }
            case binar: {
                this.clickBinar(clickPos);
                break;
            }
            case ternar: {
                this.clickTernar(clickPos);
                break;
            }
            case unarBinar: {
                this.clickUB(clickPos);
                break;
            }
            case nular: {
                this.clickNular(clickPos);
                break;
            }
            case unarNular: {
                this.clickUN(clickPos);
                break;
            }
            default: {
                super.click(clickPos);
            }
        }
    }

    public void drag(Int2D clickPos, Int2D delta, Frame f) {
        switch (this.fType) {
            case unar: {
                this.dragUnar(clickPos, delta, f);
                break;
            }
            case binar: {
                this.dragBinar(clickPos, delta, f);
                break;
            }
            case ternar: {
                this.dragTernar(clickPos, delta, f);
                break;
            }
            case unarBinar: {
                this.dragUB(clickPos, delta, f);
                break;
            }
            case nular: {
                this.dragNular(clickPos, delta, f);
                break;
            }
            case unarNular: {
                this.dragUN(clickPos, delta, f);
                break;
            }
            default: {
                super.drag(clickPos, delta, f);
            }
        }
    }

    public Int2D getArrowEnd(int i) {
        switch (this.fType) {
            case unar: {
                return this.pos().plus(arrowEndUnar);
            }
            case binar: {
                return this.pos().plus(arrowEndsBinar[i]);
            }
            case ternar: {
                return this.pos().plus(arrowEndsTernar[i]);
            }
            case unarBinar: {
                return this.pos().plus(arrowEndUB);
            }
            case unarNular: {
                return this.pos().plus(arrowEndUnar);
            }
        }
        return this.pos().plus(arrowEndUnar);
    }

    private void clickUnar(Int2D clickPos) {
        if (this.topArrowBarHitUnar(clickPos)) {
            this.topArrowBarUnar();
        } else if (this.bottomArrowBarHitUnar(clickPos)) {
            this.bottomArrowBarUnar();
        }
        super.click(clickPos);
    }

    private void dragUnar(Int2D clickPos, Int2D delta, Frame f) {
        if (this.topArrowBarHitUnar(clickPos)) {
            this.topArrowBarUnar();
        } else if (this.bottomArrowBarHitUnar(clickPos)) {
            // empty if block
        }
        super.drag(clickPos, delta, f);
    }

    private void topArrowBarUnar() {
        Outputable from = Global.rucksack().getFrom();
        int fromPort = Global.rucksack().getFromPort();
        if (from != null) {
            from.setTargetAndPort(fromPort, this, 0);
            Global.rucksack().resetFrom();
        }
    }

    private void bottomArrowBarUnar() {
        this.setTargetAndPort(0, null, -1);
        Global.rucksack().setFrom(this, 0);
    }

    private boolean topArrowBarHitUnar(Int2D clickPos) {
        return clickPos.minus(this.pos()).getY() < 10;
    }

    private boolean bottomArrowBarHitUnar(Int2D clickPos) {
        return clickPos.minus(this.pos()).getY() > 40;
    }

    private void clickBinar(Int2D clickPos) {
        if (this.topArrowBarHit0Binar(clickPos)) {
            this.topArrowBar0Binar();
        } else if (this.topArrowBarHit1Binar(clickPos)) {
            this.topArrowBar1Binar();
        } else if (this.bottomArrowBarHitBinar(clickPos)) {
            this.bottomArrowBarBinar();
        }
        super.click(clickPos);
    }

    private void dragBinar(Int2D clickPos, Int2D delta, Frame f) {
        if (this.topArrowBarHit0Binar(clickPos)) {
            this.topArrowBar0Binar();
        } else if (this.topArrowBarHit1Binar(clickPos)) {
            this.topArrowBar1Binar();
        } else if (this.bottomArrowBarHitBinar(clickPos)) {
            // empty if block
        }
        super.drag(clickPos, delta, f);
    }

    private void topArrowBar0Binar() {
        Outputable from = Global.rucksack().getFrom();
        int fromPort = Global.rucksack().getFromPort();
        if (from != null) {
            from.setTargetAndPort(fromPort, this, 0);
            Global.rucksack().resetFrom();
        }
    }

    private void topArrowBar1Binar() {
        Outputable from = Global.rucksack().getFrom();
        int fromPort = Global.rucksack().getFromPort();
        if (from != null) {
            from.setTargetAndPort(fromPort, this, 1);
            Global.rucksack().resetFrom();
        }
    }

    private void bottomArrowBarBinar() {
        this.setTargetAndPort(0, null, -1);
        Global.rucksack().setFrom(this, 0);
    }

    private boolean topArrowBarHit0Binar(Int2D clickPos) {
        Int2D p = clickPos.minus(this.pos());
        return p.getY() < 10 && p.getX() < 33;
    }

    private boolean topArrowBarHit1Binar(Int2D clickPos) {
        Int2D p = clickPos.minus(this.pos());
        return p.getY() < 10 && p.getX() > 33;
    }

    private boolean bottomArrowBarHitBinar(Int2D clickPos) {
        return clickPos.minus(this.pos()).getY() > 40;
    }

    private void clickTernar(Int2D clickPos) {
        if (this.topArrowBarHit0Ternar(clickPos)) {
            this.topArrowBar0Ternar();
        } else if (this.topArrowBarHit1Ternar(clickPos)) {
            this.topArrowBar1Ternar();
        } else if (this.topArrowBarHit2Ternar(clickPos)) {
            this.topArrowBar2Ternar();
        } else if (this.bottomArrowBarHitTernar(clickPos)) {
            this.bottomArrowBarTernar();
        }
        super.click(clickPos);
    }

    private void dragTernar(Int2D clickPos, Int2D delta, Frame f) {
        if (this.topArrowBarHit0Ternar(clickPos)) {
            this.topArrowBar0Ternar();
        } else if (this.topArrowBarHit1Ternar(clickPos)) {
            this.topArrowBar1Ternar();
        } else if (this.topArrowBarHit2Ternar(clickPos)) {
            this.topArrowBar2Ternar();
        } else if (this.bottomArrowBarHitTernar(clickPos)) {
            // empty if block
        }
        super.drag(clickPos, delta, f);
    }

    private void topArrowBar0Ternar() {
        Outputable from = Global.rucksack().getFrom();
        int fromPort = Global.rucksack().getFromPort();
        if (from != null) {
            from.setTargetAndPort(fromPort, this, 0);
            Global.rucksack().resetFrom();
        }
    }

    private void topArrowBar1Ternar() {
        Outputable from = Global.rucksack().getFrom();
        int fromPort = Global.rucksack().getFromPort();
        if (from != null) {
            from.setTargetAndPort(fromPort, this, 1);
            Global.rucksack().resetFrom();
        }
    }

    private void topArrowBar2Ternar() {
        Outputable from = Global.rucksack().getFrom();
        int fromPort = Global.rucksack().getFromPort();
        if (from != null) {
            from.setTargetAndPort(fromPort, this, 2);
            Global.rucksack().resetFrom();
        }
    }

    private void bottomArrowBarTernar() {
        this.setTargetAndPort(0, null, -1);
        Global.rucksack().setFrom(this, 0);
    }

    private boolean topArrowBarHit0Ternar(Int2D clickPos) {
        Int2D p = clickPos.minus(this.pos());
        return p.getY() < 10 && p.getX() < 33;
    }

    private boolean topArrowBarHit1Ternar(Int2D clickPos) {
        Int2D p = clickPos.minus(this.pos());
        return p.getY() < 10 && p.getX() > 33 && p.getX() < 67;
    }

    private boolean topArrowBarHit2Ternar(Int2D clickPos) {
        Int2D p = clickPos.minus(this.pos());
        return p.getY() < 10 && p.getX() > 67;
    }

    private boolean bottomArrowBarHitTernar(Int2D clickPos) {
        return clickPos.minus(this.pos()).getY() > 40;
    }

    private void clickUB(Int2D clickPos) {
        if (this.topArrowBarHitUB(clickPos)) {
            this.topArrowBarUB();
        } else if (this.bottomArrowBarHit0UB(clickPos)) {
            this.bottomArrowBar0UB();
        } else if (this.bottomArrowBarHit1UB(clickPos)) {
            this.bottomArrowBar1UB();
        }
        super.click(clickPos);
    }

    private void dragUB(Int2D clickPos, Int2D delta, Frame f) {
        if (this.topArrowBarHitUB(clickPos)) {
            this.topArrowBarUB();
        } else if (this.bottomArrowBarHit0UB(clickPos) || this.bottomArrowBarHit1UB(clickPos)) {
            // empty if block
        }
        super.drag(clickPos, delta, f);
    }

    private void topArrowBarUB() {
        Outputable from = Global.rucksack().getFrom();
        int fromPort = Global.rucksack().getFromPort();
        if (from != null) {
            from.setTargetAndPort(fromPort, this, 0);
            Global.rucksack().resetFrom();
        }
    }

    private void bottomArrowBar0UB() {
        this.setTargetAndPort(0, null, -1);
        Global.rucksack().setFrom(this, 0);
    }

    private void bottomArrowBar1UB() {
        this.setTargetAndPort(1, null, -1);
        Global.rucksack().setFrom(this, 1);
    }

    private boolean topArrowBarHitUB(Int2D clickPos) {
        return clickPos.minus(this.pos()).getY() < 10;
    }

    private boolean bottomArrowBarHit0UB(Int2D clickPos) {
        Int2D p = clickPos.minus(this.pos());
        return p.getY() > 40 && p.getX() < 25;
    }

    private boolean bottomArrowBarHit1UB(Int2D clickPos) {
        Int2D p = clickPos.minus(this.pos());
        return p.getY() > 40 && p.getX() > 25;
    }

    private void clickNular(Int2D clickPos) {
        if (this.bottomArrowBarHitNular(clickPos)) {
            this.bottomArrowBarNular();
        }
        super.click(clickPos);
    }

    private void dragNular(Int2D clickPos, Int2D delta, Frame f) {
        if (this.bottomArrowBarHitNular(clickPos)) {
            // empty if block
        }
        super.drag(clickPos, delta, f);
    }

    private void bottomArrowBarNular() {
        this.setTargetAndPort(0, null, -1);
        Global.rucksack().setFrom(this, 0);
    }

    private boolean bottomArrowBarHitNular(Int2D clickPos) {
        return clickPos.minus(this.pos()).getY() > 30;
    }

    private void clickUN(Int2D clickPos) {
        if (this.topArrowBarHitUN(clickPos)) {
            this.topArrowBarUN();
        }
        super.click(clickPos);
    }

    private void dragUN(Int2D clickPos, Int2D delta, Frame f) {
        if (this.topArrowBarHitUN(clickPos)) {
            this.topArrowBarUN();
        }
        super.drag(clickPos, delta, f);
    }

    private void topArrowBarUN() {
        Outputable from = Global.rucksack().getFrom();
        int fromPort = Global.rucksack().getFromPort();
        if (from != null) {
            from.setTargetAndPort(fromPort, this, 0);
            Global.rucksack().resetFrom();
        }
    }

    private boolean topArrowBarHitUN(Int2D clickPos) {
        return clickPos.minus(this.pos()).getY() < 10;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FType {
        nular,
        unarNular,
        unar,
        binar,
        ternar,
        unarBinar,
        other;

    }
}

