/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import kutil.core.Global;
import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.items.StringItem;
import kutil.kobjects.Basic;
import kutil.kobjects.Frame;
import kutil.kobjects.Function;
import kutil.kobjects.InCollisionListener;
import kutil.kobjects.Inputable;
import kutil.kobjects.KObject;
import kutil.kobjects.Outputable;
import kutil.shapes.InShape;
import net.phys2d.raw.World;

public class In
extends Basic
implements Outputable {
    private StringItem targetString;
    private Inputable target;
    private int targetPort;
    private World parentWorld;
    private InCollisionListener listener;

    public In(KAtts kAtts) {
        super(kAtts);
        this.targetString = this.items().addString(kAtts, "target", "");
        this.create();
    }

    public In(In in) {
        super(in);
        this.targetString = this.items().addString("target", in.targetString.get());
        this.create();
    }

    public In() {
        this.targetString = this.items().addString("target", "");
        this.create();
    }

    public KObject copy() {
        return new In(this);
    }

    private void create() {
        this.setType("in");
        this.setPhysical(true);
        this.setAttached(true);
        this.setShape(new InShape(this));
    }

    public void init() {
        super.init();
        this.resetCollisionListener();
        this.resetTargets();
    }

    public void resolveCopying() {
        super.resolveCopying();
        if (this.isCopied()) {
            String newTargetString = Global.idChangeDB().repairTargetString(this.targetString.get());
            this.targetString.set(newTargetString);
            if (this.targetString.get() != null) {
                this.resetTargets();
            }
        }
    }

    public void resolveRenaming(String oldId, String newId) {
        super.resolveRenaming(oldId, newId);
        this.targetString.set(Function.repairTarget(oldId, newId, this.targetString.get()));
        if (this.targetString.get() != null) {
            this.resetTargets();
        }
    }

    public void setParent(KObject newParent) {
        super.setParent(newParent);
        this.resetCollisionListener();
    }

    private void resetCollisionListener() {
        if (this.parentWorld != null) {
            this.parentWorld.removeListener(this.listener);
        }
        this.parentWorld = this.getParentWorld();
        if (this.parentWorld != null) {
            this.listener = new InCollisionListener(this);
            this.parentWorld.addListener(this.listener);
        }
    }

    public void delete() {
        super.delete();
        if (this.parentWorld != null) {
            this.parentWorld.removeListener(this.listener);
        }
    }

    public void click(Int2D clickPos) {
        if (this.bottomArrowBarHit(clickPos)) {
            this.bottomArrowBar();
        }
        super.click(clickPos);
    }

    public void drag(Int2D clickPos, Int2D delta, Frame f) {
        if (this.bottomArrowBarHit(clickPos)) {
            // empty if block
        }
        super.drag(clickPos, delta, f);
    }

    private void bottomArrowBar() {
        this.setTargetAndPort(0, null, -1);
        Global.rucksack().setFrom(this, 0);
    }

    private boolean bottomArrowBarHit(Int2D clickPos) {
        return clickPos.minus(this.pos()).getY() > 9;
    }

    private void resetTargets() {
        if (this.targetString.get().equals("null")) {
            this.target = null;
            this.targetPort = -1;
            return;
        }
        String[] parts = this.targetString.get().split(":");
        KObject o = this.idDB().get(parts[0]);
        if (o instanceof Inputable) {
            this.target = (Inputable)((Object)o);
            this.targetPort = Integer.parseInt(parts[1]);
        }
    }

    public void setTargetAndPort(int fromPort, Inputable t, int p) {
        int i;
        String[] ts = this.targetString.get() != null ? this.targetString.get().split(" ") : new String[]{};
        if (ts.length <= fromPort) {
            String[] ts2 = new String[fromPort + 1];
            System.arraycopy(ts, 0, ts2, 0, ts.length);
            for (i = ts.length; i < ts2.length; ++i) {
                ts2[i] = "null";
            }
            ts = ts2;
        }
        ts[fromPort] = t != null ? t.id() + ":" + p : "null";
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < ts.length; ++i) {
            sb.append(ts[i]);
            if (i == ts.length - 1) continue;
            sb.append(" ");
        }
        this.targetString.set(sb.toString());
        this.resetTargets();
    }

    public void handleWorldInput(KObject input) {
        input.remove();
        if (this.target != null) {
            this.target.handleInput(input, this.targetPort);
        }
    }

    public Int2D getTargetArrowEnd() {
        if (this.target == null) {
            return this.pos();
        }
        return this.target.getArrowEnd(this.targetPort);
    }

    public boolean doDrawArrow() {
        if (this.target == null) {
            return false;
        }
        return this.target.parent() == this.parent();
    }
}

