/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.kobjects.Fly;
import kutil.kobjects.Function;
import kutil.kobjects.KObject;
import kutil.kobjects.KObjectFactory;
import kutil.kobjects.PortNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Incubator
extends Function {
    private static final int maxLayers = 6;
    private static final int maxInOneLayer = 6;

    public Incubator(KAtts kAtts) {
        super(kAtts);
        this.create();
    }

    public Incubator(Incubator i) {
        super(i);
        this.create();
    }

    @Override
    public KObject copy() {
        return new Incubator(this);
    }

    private void create() {
        this.setType("incubator");
        this.resetVal("incubator");
    }

    public Fly getFly() {
        if (this.inside().isEmpty()) {
            return null;
        }
        LinkedList<Function> topTerminals = new LinkedList<Function>();
        LinkedList<Function> functions = new LinkedList<Function>();
        LinkedList<Function> bottomTerminals = new LinkedList<Function>();
        for (KObject o : this.inside()) {
            if (!(o instanceof Function)) continue;
            Function f = (Function)o;
            if (f.getImplementation().numArgs() == 0) {
                topTerminals.add(f);
                continue;
            }
            if (f.getImplementation().numOutputs() == 0) {
                bottomTerminals.add(f);
                continue;
            }
            functions.add(f);
        }
        if (topTerminals.isEmpty() || bottomTerminals.isEmpty()) {
            return null;
        }
        int numLayers = functions.isEmpty() ? 2 : this.rand().nextInt(4) + 3;
        Fly fly = (Fly)KObjectFactory.insertKObjectToSystem(new Fly(), null);
        int lastSumOutputs = -1;
        LinkedList<PortNode> outputs = null;
        LinkedList<PortNode> newOutputs = null;
        LinkedList<PortNode> inputs = null;
        block1: for (int i = 0; i < numLayers; ++i) {
            int k;
            LinkedList<Function> fs = i == 0 ? topTerminals : (i == numLayers - 1 ? bottomTerminals : functions);
            LinkedList<Function> layer = new LinkedList<Function>();
            int sumOutputs = 0;
            int sumInputs = 0;
            if (i == 0) {
                int numInLayer = this.rand().nextInt(6) + 1;
                LinkedList<PortNode> outList = new LinkedList<PortNode>();
                for (int j = 0; j < numInLayer; ++j) {
                    Function f = this.randomFunction(fs);
                    layer.add(f);
                    int numOutputs = f.getImplementation().numOutputs();
                    sumOutputs += numOutputs;
                    for (k = 0; k < numOutputs; ++k) {
                        outList.add(new PortNode(f, k));
                    }
                }
                newOutputs = outList;
            } else {
                Function f;
                int numInputs;
                LinkedList<PortNode> outList = new LinkedList<PortNode>();
                LinkedList<PortNode> inList = new LinkedList<PortNode>();
                while ((sumInputs += (numInputs = (f = this.randomFunction(fs)).getImplementation().numArgs())) <= lastSumOutputs) {
                    layer.add(f);
                    int numOutputs = f.getImplementation().numOutputs();
                    sumOutputs += numOutputs;
                    for (k = 0; k < numInputs; ++k) {
                        inList.add(new PortNode(f, k));
                    }
                    for (k = 0; k < numOutputs; ++k) {
                        outList.add(new PortNode(f, k));
                    }
                }
                outputs = newOutputs;
                newOutputs = outList;
                inputs = inList;
            }
            lastSumOutputs = sumOutputs;
            int j = 0;
            for (Function f : layer) {
                this.insert(f, fly, j * 100, i * 100);
                ++j;
            }
            if (inputs == null) continue;
            Collections.shuffle(inputs, Global.random());
            int numConnected = 0;
            for (PortNode n : outputs) {
                PortNode input;
                Function f = n.function;
                int port = n.port;
                if (numConnected < inputs.size()) {
                    input = (PortNode)inputs.get(numConnected);
                } else {
                    if (inputs.size() <= 0) continue block1;
                    input = (PortNode)inputs.get(this.rand().nextInt(inputs.size()));
                }
                f.setTargetAndPort(port, input.function, input.port);
                ++numConnected;
            }
        }
        return fly;
    }

    private Function insert(Function f, Fly fly, int x, int y) {
        KObjectFactory.insertKObjectToSystem(f, fly);
        f.setPos(new Int2D(x, y));
        fly.directAdd(f);
        return f;
    }

    private Function randomFunction(LinkedList<Function> fs) {
        return (Function)fs.get(this.rand().nextInt(fs.size())).copy();
    }

    private Random rand() {
        return Global.random();
    }
}

