/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import java.util.LinkedList;
import kutil.core.Global;
import kutil.core.KAtts;
import kutil.kobjects.Apple;
import kutil.kobjects.Basic;
import kutil.kobjects.Bool;
import kutil.kobjects.Box;
import kutil.kobjects.Budha;
import kutil.kobjects.Button;
import kutil.kobjects.Clock;
import kutil.kobjects.Comment;
import kutil.kobjects.Direction;
import kutil.kobjects.FFUnit;
import kutil.kobjects.Field;
import kutil.kobjects.Fly;
import kutil.kobjects.Frame;
import kutil.kobjects.Function;
import kutil.kobjects.GoalSensor;
import kutil.kobjects.In;
import kutil.kobjects.Incubator;
import kutil.kobjects.KObject;
import kutil.kobjects.Logger;
import kutil.kobjects.Mr;
import kutil.kobjects.MultiObject;
import kutil.kobjects.Num;
import kutil.kobjects.Out;
import kutil.kobjects.Panacek;
import kutil.kobjects.Recursion;
import kutil.kobjects.Slot;
import kutil.kobjects.Symbol;
import kutil.kobjects.Text;
import kutil.kobjects.Time;
import kutil.kobjects.Tool;
import kutil.kobjects.TouchSensor;
import kutil.kobjects.Wasp;
import kutil.kobjects.WebOutput;
import kutil.xml.XmlLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KObjectFactory {
    public static KObject newKObject(KAtts kAtts) {
        KObject type = kAtts.get("type");
        String typeName = "basic";
        if (type instanceof Text) {
            typeName = ((Text)type).get();
        }
        if ("basic".equals(typeName)) {
            return new Basic(kAtts);
        }
        if ("button".equals(typeName)) {
            return new Button(kAtts);
        }
        if ("frame".equals(typeName)) {
            return new Frame(kAtts);
        }
        if ("function".equals(typeName)) {
            return new Function(kAtts);
        }
        if ("in".equals(typeName)) {
            return new In(kAtts);
        }
        if ("logger".equals(typeName)) {
            return new Logger(kAtts);
        }
        if ("num".equals(typeName)) {
            return new Num(kAtts);
        }
        if ("out".equals(typeName)) {
            return new Out(kAtts);
        }
        if ("time".equals(typeName)) {
            return new Time(kAtts);
        }
        if ("tool".equals(typeName)) {
            return new Tool(kAtts);
        }
        if ("box".equals(typeName)) {
            return new Box(kAtts);
        }
        if ("fly".equals(typeName)) {
            return new Fly(kAtts);
        }
        if ("wasp".equals(typeName)) {
            return new Wasp(kAtts);
        }
        if ("apple".equals(typeName)) {
            return new Apple(kAtts);
        }
        if ("bool".equals(typeName)) {
            return new Bool(kAtts);
        }
        if ("symbol".equals(typeName)) {
            return new Symbol(kAtts);
        }
        if ("recursion".equals(typeName)) {
            return new Recursion(kAtts);
        }
        if ("direction".equals(typeName)) {
            return new Direction(kAtts);
        }
        if ("slot".equals(typeName)) {
            return new Slot(kAtts);
        }
        if ("comment".equals(typeName)) {
            return new Comment(kAtts);
        }
        if ("budha".equals(typeName)) {
            return new Budha(kAtts);
        }
        if ("mr".equals(typeName)) {
            return new Mr(kAtts);
        }
        if ("field".equals(typeName)) {
            return new Field(kAtts);
        }
        if ("ffunit".equals(typeName)) {
            return new FFUnit(kAtts);
        }
        if ("multiobject".equals(typeName)) {
            return new MultiObject(kAtts);
        }
        if ("panacek".equals(typeName)) {
            return new Panacek(kAtts);
        }
        if ("touchSensor".equals(typeName)) {
            return new TouchSensor(kAtts);
        }
        if ("goalSensor".equals(typeName)) {
            return new GoalSensor(kAtts);
        }
        if ("webOutput".equals(typeName)) {
            return new WebOutput(kAtts);
        }
        if ("clock".equals(typeName)) {
            return new Clock(kAtts);
        }
        if ("incubator".equals(typeName)) {
            return new Incubator(kAtts);
        }
        return new Basic(kAtts);
    }

    public static KObject newKObject(String xmlString) {
        XmlLoader loader = new XmlLoader();
        KAtts kAtts = loader.loadString("<kutil>" + xmlString + "</kutil>");
        return kAtts.get("kutil");
    }

    public static LinkedList<KObject> newKObjectFromResource(String filename) {
        XmlLoader loader = new XmlLoader();
        KAtts kAtts = loader.loadResource(filename);
        return kAtts.getList("kutil");
    }

    public static LinkedList<KObject> newKObjectFromFile(String filename) {
        XmlLoader loader = new XmlLoader();
        KAtts kAtts = loader.loadFile(filename);
        return kAtts.getList("kutil");
    }

    public static KObject insertKObjectToSystem(KObject newKObject, KObject parent) {
        newKObject.parentInfo(parent);
        newKObject.init();
        newKObject.resolveCopying();
        Global.idChangeDB().clear();
        return newKObject;
    }
}

