/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import java.util.List;
import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.items.ListItem;
import kutil.kobjects.Basic;
import kutil.kobjects.KObject;
import kutil.shapes.MultiShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiObject
extends Basic {
    private ListItem obs;

    public MultiObject(KAtts kAtts) {
        super(kAtts);
        this.obs = this.items().addList(kAtts, "obs");
        this.create();
    }

    public MultiObject(MultiObject mo) {
        super(mo);
        this.obs = this.items().addEmptyList("obs");
        for (KObject o : mo.obs.get()) {
            KObject copy = o.copy();
            this.obs.get().add(copy);
        }
        this.create();
    }

    public MultiObject(List<KObject> bricks) {
        this.obs = this.items().addEmptyList("obs");
        for (KObject o : bricks) {
            this.obs.get().add(o);
        }
        this.create();
        Int2D pos = ((MultiShape)this.getShape()).getPivot().pos();
        this.setPos(pos);
        for (KObject o : this.obs.get()) {
            o.setPos(o.pos().minus(pos));
        }
    }

    private void create() {
        this.setType("multiobject");
        MultiShape shape = new MultiShape(this.obs.get());
        this.setShape(shape);
    }

    @Override
    public KObject copy() {
        return new MultiObject(this);
    }
}

