/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.core.Log;
import kutil.kobjects.Frame;
import kutil.kobjects.MyActionMap;
import kutil.kobjects.MyInputMap;

class MyJPanel
extends JPanel
implements ComponentListener,
MouseInputListener {
    private Frame frame;
    private MyActionMap myActionMap;
    private MyInputMap myInputMap;
    private Image image;
    private Graphics2D graphics2D;
    private static final RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private int dragHelpX;
    private int dragHelpY;

    public MyJPanel(Frame f) {
        this.frame = f;
        this.myInputMap = new MyInputMap();
        this.myInputMap.setParent(this.getInputMap(0));
        this.setInputMap(0, this.myInputMap);
        this.myActionMap = new MyActionMap(this.frame);
        this.setActionMap(this.myActionMap);
        String[] keyNames = Global.rucksack().getKeyNames();
        for (int i = 0; i < keyNames.length; ++i) {
            this.registerKeyboardEvent(keyNames[i]);
        }
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void resetImage() {
        this.image = this.createImage(this.frame.getSize().getX(), this.frame.getSize().getY());
        if (this.image == null) {
            System.out.println("dbImage is null");
            return;
        }
        this.graphics2D = (Graphics2D)this.image.getGraphics();
        this.graphics2D.setRenderingHints(renderingHints);
        this.graphics2D.setClip(0, 0, this.frame.getSize().getX(), this.frame.getSize().getY());
    }

    public void paintScreen() {
        this.gameRender();
        try {
            Graphics g = this.getGraphics();
            if (g != null && this.image != null) {
                g.drawImage(this.image, 0, 0, null);
            }
            g.dispose();
        }
        catch (Exception e) {
            System.out.println("Graphics context error: " + e);
        }
    }

    private void gameRender() {
        if (this.image == null) {
            this.resetImage();
        }
        if (this.graphics2D == null) {
            Log.it("CHYBA JE V TOM \u017ee graphics2D == null !!!");
            return;
        }
        this.graphics2D.setColor(Color.white);
        this.graphics2D.fillRect(0, 0, this.frame.getSize().getX(), this.frame.getSize().getY());
        this.frame.paintScreen(this.graphics2D);
        this.frame.rucksack().paintScreen(this.graphics2D);
    }

    public final void registerKeyboardEvent(String event) {
        this.myActionMap.putNewAction(event);
        this.myInputMap.putNewInput(event);
    }

    public void mouseClicked(MouseEvent e) {
        this.frame.mouseClicked(e);
    }

    public void mousePressed(MouseEvent e) {
        this.frame.mousePressed(e);
        this.dragHelpX = e.getX();
        this.dragHelpY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        this.frame.mouseReleased(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.frame.mouseDragged(e, new Int2D(e.getX() - this.dragHelpX, e.getY() - this.dragHelpY));
        this.dragHelpX = e.getX();
        this.dragHelpY = e.getY();
    }

    public void mouseMoved(MouseEvent e) {
        this.frame.mouseMoved(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.frame.resetSize(e.getComponent().getWidth(), e.getComponent().getHeight());
        this.resetImage();
    }
}

