/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import kutil.core.Global;
import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.kobjects.Basic;
import kutil.kobjects.Frame;
import kutil.kobjects.Inputable;
import kutil.kobjects.KObject;
import kutil.kobjects.Outputable;
import kutil.shapes.OutShape;

public class Out
extends Basic
implements Inputable {
    private static final Int2D shift = new Int2D(16, 40);
    private static final Int2D arrowEnd = new Int2D(16, -1);

    public Out(KAtts kAtts) {
        super(kAtts);
        this.create();
    }

    public Out(Out o) {
        super(o);
        this.create();
    }

    public Out() {
        this.create();
    }

    public KObject copy() {
        return new Out(this);
    }

    private void create() {
        this.setType("out");
        this.setShape(new OutShape());
    }

    public void handleInput(KObject input, int port) {
        if (input == null) {
            return;
        }
        input.setPos(this.pos().plus(shift));
        this.parent().add(input);
        input.setParent(this.parent());
    }

    public void handleOutsideInput(KObject input, int port) {
    }

    public Int2D getArrowEnd(int i) {
        return this.pos().plus(arrowEnd);
    }

    public void click(Int2D clickPos) {
        if (this.topArrowBarHit(clickPos)) {
            this.topArrowBar();
        }
        super.click(clickPos);
    }

    public void drag(Int2D clickPos, Int2D delta, Frame f) {
        if (this.topArrowBarHit(clickPos)) {
            this.topArrowBar();
        }
        super.drag(clickPos, delta, f);
    }

    private void topArrowBar() {
        Outputable from = Global.rucksack().getFrom();
        int fromPort = Global.rucksack().getFromPort();
        if (from != null) {
            from.setTargetAndPort(fromPort, this, 0);
            Global.rucksack().resetFrom();
        }
    }

    private boolean topArrowBarHit(Int2D clickPos) {
        return clickPos.minus(this.pos()).getY() < 9;
    }
}

