/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

class Page {
    private String[] lines;
    private int longestLine;
    private int pageNumber;
    private int numPages;

    public Page(String str, int pageNumber, int numPages) {
        this.lines = str.split("#");
        this.pageNumber = pageNumber;
        this.numPages = numPages;
        this.longestLine = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = this.lines[i].trim();
            if (this.longestLine >= this.lines[i].length()) continue;
            this.longestLine = this.lines[i].length();
        }
    }

    public String line(int i) {
        if (i == this.lines.length) {
            return "";
        }
        if (i == this.lines.length + 1) {
            return this.pageNumber + "/" + this.numPages;
        }
        return this.lines[i];
    }

    public int numLines() {
        return this.numPages > 1 ? this.lines.length + 2 : this.lines.length;
    }

    public int longestLine() {
        return this.longestLine;
    }
}

