/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import kutil.core.Int2D;
import kutil.core.KAtts;
import kutil.core.Log;
import kutil.items.IntegerItem;
import kutil.kobjects.Function;
import kutil.kobjects.KObject;
import kutil.kobjects.KObjectFactory;
import kutil.shapes.RecursionShape;

public class Recursion
extends Function {
    private IntegerItem depth;

    public Recursion(KAtts kAtts) {
        super(kAtts);
        this.depth = this.items().addInteger(kAtts, "depth", -1);
        this.create();
    }

    public Recursion(Recursion r) {
        super(r);
        this.depth = this.items().addInteger("depth", r.depth.get());
        this.create();
    }

    public KObject copy() {
        return new Recursion(this);
    }

    private void create() {
        this.setType("recursion");
        this.setShape(new RecursionShape(this));
        this.depth.set(this.depth.get() + 1);
    }

    public void doAfterComputation() {
        this.changeInsideTargets(null);
        this.clearAfterAdding();
    }

    public void doBeforeComputation() {
        if (this.depth.get() > 500) {
            Log.it("ERROR: Recursion depth is to big!");
            return;
        }
        KObject parentCopy = this.parent().copy();
        if (parentCopy instanceof Function) {
            KObjectFactory.insertKObjectToSystem(parentCopy, this);
            this.add(parentCopy);
            parentCopy.setPos(new Int2D(200, 200));
            this.changeInsideTargets(parentCopy.id() + ":0");
            ((Function)parentCopy).changeOutsideTargets(this.id() + ":0");
            ((Function)parentCopy).changeTargets(null);
        }
    }
}

