/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import kutil.core.KAtts;
import kutil.items.DoubleItem;
import kutil.items.IntegerItem;
import kutil.kobjects.Basic;

public class Time
extends Basic {
    private DoubleItem ups;
    private IntegerItem iterations;
    private long period;

    public Time(KAtts kAtts) {
        super(kAtts);
        this.setType("time");
        this.ups = this.items().addDouble(kAtts, "ups", 80.0);
        this.iterations = this.items().addInteger(kAtts, "iterations", null);
        this.period = Math.round(1000.0 / this.ups.get());
    }

    public double getUPS() {
        return this.ups.get();
    }

    public long getPeriod() {
        return this.period;
    }

    public long getIterations() {
        return this.iterations.get().intValue();
    }

    public void decrementIterations() {
        if (this.iterations.get() == null) {
            return;
        }
        this.iterations.set(this.iterations.get() - 1);
    }

    public boolean isFinished() {
        if (this.iterations.get() == null) {
            return false;
        }
        return this.iterations.get() <= 0;
    }
}

