/*
 * Decompiled with CFR 0.152.
 */
package kutil.kobjects;

import kutil.core.Global;
import kutil.core.KAtts;
import kutil.core.WebSlot;
import kutil.kobjects.Function;
import kutil.kobjects.KObject;
import kutil.kobjects.KObjectFactory;

public class WebOutput
extends Function {
    private long lastCheck;
    private KObject lastBullet;

    public WebOutput(KAtts kAtts) {
        super(kAtts);
        this.create();
    }

    public WebOutput(WebOutput wo) {
        super(wo);
        this.create();
    }

    public void step() {
        super.step();
        if (Global.rucksack().isSimulationRunning() && WebOutput.time() - this.lastCheck > 1000L) {
            this.lastCheck = WebOutput.time();
            String webXML = WebSlot.getWebSlot("kutil");
            if (!webXML.equals("")) {
                WebSlot.setWebSlot_get("kutil", "");
                KObject o = KObjectFactory.newKObject(webXML).copy();
                this.fire(o);
            }
        }
    }

    public KObject copy() {
        return new WebOutput(this);
    }

    private void create() {
        this.setType("webOutput");
        this.resetVal("webOutput");
        this.lastCheck = WebOutput.time();
    }

    public void fire(KObject bullet) {
        this.lastBullet = bullet;
        this.handleInput(bullet, 0);
    }

    public KObject getLastBullet() {
        return this.lastBullet;
    }

    private static long time() {
        return System.currentTimeMillis();
    }
}

