/*
 * Decompiled with CFR 0.152.
 */
package kutil.shapes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.shapes.KShape;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.shapes.Circle;
import net.phys2d.raw.shapes.DynamicShape;

public class CircleShape
implements KShape {
    private int r;
    private Color color;
    private Circle phys2DCircle;
    private static final Font idFont = new Font("SansSerif", 0, 10);

    public CircleShape(int r, Color color) {
        this.r = r;
        this.color = color;
        this.phys2DCircle = new Circle(r);
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void draw(Graphics2D g, boolean isSelected, String info, Int2D pos, Int2D center, double rot, boolean isRotable) {
        Int2D drawPos = center.plus(pos);
        float xo = (float)(Math.cos(rot) * (double)this.r);
        float yo = (float)(Math.sin(rot) * (double)this.r);
        g.setColor(this.color);
        g.fillOval(drawPos.getX() - this.r, drawPos.getY() - this.r, this.r * 2, this.r * 2);
        if (this.color == Color.white) {
            g.setColor(Color.black);
            g.drawOval(drawPos.getX() - this.r, drawPos.getY() - this.r, this.r * 2, this.r * 2);
        }
        if (isSelected) {
            g.setColor(Color.red);
            g.drawOval(drawPos.getX() - this.r, drawPos.getY() - this.r, this.r * 2, this.r * 2);
            g.drawLine(drawPos.getX(), drawPos.getY(), (int)((float)drawPos.getX() + xo), (int)((float)drawPos.getY() + yo));
        }
        if (Global.rucksack().showInfo()) {
            g.setFont(idFont);
            g.drawString(info, drawPos.getX() - this.r, drawPos.getY() - this.r);
        }
    }

    public boolean isHit(Int2D pos, Int2D clickPos, double rot) {
        int dy;
        int dx = pos.getX() - clickPos.getX();
        return dx * dx + (dy = pos.getY() - clickPos.getY()) * dy < this.r * this.r;
    }

    public DynamicShape getPhys2dShape() {
        return this.phys2DCircle;
    }

    public ROVector2f getPhys2dCenter(Int2D pos) {
        return new Vector2f(pos.getX(), pos.getY());
    }

    public Int2D getPosByPhys2dCenter(ROVector2f v) {
        return new Int2D((int)v.getX(), (int)v.getY());
    }
}

