/*
 * Decompiled with CFR 0.152.
 */
package kutil.shapes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.shapes.KShape;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.shapes.ConvexPolygon;
import net.phys2d.raw.shapes.DynamicShape;

public class ConvexPolygonShape
implements KShape {
    private Color color;
    private ConvexPolygon convexPolygon;
    protected Int2D posPoint;
    protected Int2D t;
    private static final Color highlightColor = Color.red;
    private static final Font idFont = new Font("SansSerif", 0, 10);

    public ConvexPolygonShape(Int2D[] vs, Int2D posPoint, Int2D t, Color c) {
        this.color = c;
        posPoint = posPoint.minus(t);
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = vs[i].minus(t);
        }
        this.t = t;
        this.convexPolygon = new ConvexPolygon(Int2D.toROVector2f(vs));
        this.posPoint = posPoint;
    }

    public void draw(Graphics2D g, boolean isSel, String info, Int2D pos, Int2D center, double rot, boolean isRotable) {
        int i;
        Vector2f[] verts = this.convexPolygon.getVertices(this.getPhys2dCenter(pos), (float)rot);
        Int2D drawPos = center.plus(pos);
        int numVertices = this.convexPolygon.NumVertices();
        int[] polyXs = new int[numVertices];
        int[] polyYs = new int[numVertices];
        int dx = center.getX();
        int dy = center.getY();
        for (i = 0; i < verts.length; ++i) {
            polyXs[i] = (int)(0.5f + verts[i].getX()) + dx;
            polyYs[i] = (int)(0.5f + verts[i].getY()) + dy;
        }
        g.setColor(this.color);
        g.fillPolygon(polyXs, polyYs, numVertices);
        if (isSel) {
            g.setColor(highlightColor);
            i = 0;
            int j = verts.length - 1;
            while (i < verts.length) {
                g.drawLine((int)(0.5f + verts[i].getX()) + dx, (int)(0.5f + verts[i].getY()) + dy, (int)(0.5f + verts[j].getX()) + dx, (int)(0.5f + verts[j].getY()) + dy);
                j = i++;
            }
        }
        if (Global.rucksack().showInfo()) {
            g.setFont(idFont);
            g.drawString(info, drawPos.getX(), drawPos.getY() - 3);
        }
    }

    public boolean isHit(Int2D pos, Int2D clickPos, double rot) {
        Vector2f[] verts = this.convexPolygon.getVertices(this.getPhys2dCenter(pos), (float)rot);
        Vector2f p = Int2D.toROVector2f(clickPos);
        int l = verts.length;
        for (int i = 0; i < verts.length; ++i) {
            Vector2f x = verts[i];
            Vector2f y = verts[(i + 1) % l];
            Vector2f z = p;
            if (!((z.x - x.x) * (y.y - x.y) - (y.x - x.x) * (z.y - x.y) >= 0.0f)) continue;
            return false;
        }
        return true;
    }

    public DynamicShape getPhys2dShape() {
        return this.convexPolygon;
    }

    public ROVector2f getPhys2dCenter(Int2D pos) {
        return Int2D.toROVector2f(pos.minus(this.posPoint));
    }

    public Int2D getPosByPhys2dCenter(ROVector2f v) {
        return Int2D.fromROVector2f(v).plus(this.posPoint);
    }
}

