/*
 * Decompiled with CFR 0.152.
 */
package kutil.shapes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.shapes.ConvexPolygonShape;

public class ImageShape
extends ConvexPolygonShape {
    private BufferedImage image;
    private BufferedImage imageSelected;
    private int stredX;
    private int stredY;
    private static final Font idFont = new Font("SansSerif", 0, 10);

    public ImageShape(BufferedImage image, BufferedImage imageSelected, Int2D[] vs, Int2D posPoint, Int2D t) {
        super(vs, posPoint, t, Color.CYAN);
        this.image = image;
        this.imageSelected = imageSelected;
        this.stredX = t.getX();
        this.stredY = t.getY();
    }

    public void resetImage(BufferedImage img, BufferedImage imgSel) {
        this.image = img;
        this.imageSelected = imgSel;
    }

    public void draw(Graphics2D g, boolean isSel, String info, Int2D pos, Int2D center, double rot, boolean isRotable) {
        BufferedImage img = isSel ? this.imageSelected : this.image;
        Int2D drawPos = center.plus(pos);
        Int2D tPos = drawPos.minus(this.posPoint);
        if (isRotable) {
            g.translate(tPos.getX(), tPos.getY());
            g.rotate(rot);
            g.translate(-this.stredX, -this.stredY);
            g.drawImage((Image)img, 0, 0, null);
            g.translate(this.stredX, this.stredY);
            g.rotate(-rot);
            g.translate(-tPos.getX(), -tPos.getY());
        } else {
            g.drawImage((Image)img, tPos.getX() - this.stredX, tPos.getY() - this.stredY, null);
        }
        if (Global.rucksack().showInfo()) {
            g.setColor(Color.BLACK);
            g.setFont(idFont);
            g.drawString(info, drawPos.getX(), drawPos.getY() - 3);
        }
    }
}

