/*
 * Decompiled with CFR 0.152.
 */
package kutil.shapes;

import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import kutil.core.Int2D;
import kutil.kobjects.Basic;
import kutil.kobjects.KObject;
import kutil.shapes.KShape;
import net.phys2d.math.ROVector2f;
import net.phys2d.raw.shapes.DynamicShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiShape
implements KShape {
    private LinkedList<Basic> obs = new LinkedList();
    private Basic pivot;

    public MultiShape(List<KObject> os) {
        for (KObject o : os) {
            if (!(o instanceof Basic)) continue;
            Basic b = (Basic)o;
            this.obs.add(b);
        }
        if (!this.obs.isEmpty()) {
            this.pivot = this.obs.getFirst();
        }
    }

    public KObject getPivot() {
        return this.pivot;
    }

    @Override
    public void draw(Graphics2D g, boolean isSel, String info, Int2D pos, Int2D c, double rot, boolean isRotable) {
        for (Basic o : this.obs) {
            o.getShape().draw(g, isSel, o.getInfoString(), pos.plus(o.pos()), c, o.getRot(), o.getIsRotable());
        }
    }

    @Override
    public ROVector2f getPhys2dCenter(Int2D pos) {
        return this.pivot.getShape().getPhys2dCenter(pos);
    }

    @Override
    public DynamicShape getPhys2dShape() {
        return this.pivot.getShape().getPhys2dShape();
    }

    @Override
    public Int2D getPosByPhys2dCenter(ROVector2f v) {
        return this.pivot.getShape().getPosByPhys2dCenter(v);
    }

    @Override
    public boolean isHit(Int2D pos, Int2D clickPos, double rot) {
        for (Basic o : this.obs) {
            if (!o.getShape().isHit(pos.plus(o.pos()), clickPos, rot)) continue;
            return true;
        }
        return false;
    }
}

