/*
 * Decompiled with CFR 0.152.
 */
package kutil.shapes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.shapes.KShape;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.shapes.Box;
import net.phys2d.raw.shapes.DynamicShape;

public class RectangleShape
implements KShape {
    private Int2D size;
    private Color color;
    private Box phys2DBox;
    private static final Color highlightColor = Color.red;
    private static final Font idFont = new Font("SansSerif", 0, 10);

    public RectangleShape(Int2D size, Color color) {
        this.size = size;
        this.color = color;
        this.phys2DBox = new Box(size.getX(), size.getY());
    }

    public void setSize(Int2D s) {
        this.size = s;
        this.phys2DBox = new Box(this.size.getX(), this.size.getY());
    }

    public void draw(Graphics2D g, boolean isSelected, String info, Int2D pos, Int2D center, double rot, boolean isRotable) {
        Vector2f[] vs = this.phys2DBox.getPoints(this.getPhys2dCenter(pos), (float)rot);
        Int2D drawPos = center.plus(pos);
        int dx = center.getX();
        int dy = center.getY();
        int[] xs = new int[]{(int)vs[0].x + dx, (int)vs[1].x + dx, (int)vs[2].x + dx, (int)vs[3].x + dx};
        int[] ys = new int[]{(int)vs[0].y + dy, (int)vs[1].y + dy, (int)vs[2].y + dy, (int)vs[3].y + dy};
        g.setColor(this.color);
        g.fillPolygon(xs, ys, 4);
        if (this.color == Color.white) {
            g.setColor(Color.black);
            g.drawPolygon(xs, ys, 4);
        }
        if (isSelected) {
            g.setColor(highlightColor);
            g.drawPolygon(xs, ys, 4);
        }
        if (Global.rucksack().showInfo()) {
            g.setFont(idFont);
            g.drawString(info, drawPos.getX(), drawPos.getY() - 3);
        }
    }

    public boolean isHit(Int2D pos, Int2D clickPos, double rot) {
        Vector2f[] verts = this.phys2DBox.getPoints(this.getPhys2dCenter(pos), (float)rot);
        Vector2f p = Int2D.toROVector2f(clickPos);
        int l = verts.length;
        for (int i = 0; i < verts.length; ++i) {
            Vector2f x = verts[i];
            Vector2f y = verts[(i + 1) % l];
            Vector2f z = p;
            if (!((z.x - x.x) * (y.y - x.y) - (y.x - x.x) * (z.y - x.y) >= 0.0f)) continue;
            return false;
        }
        return true;
    }

    public DynamicShape getPhys2dShape() {
        return this.phys2DBox;
    }

    public ROVector2f getPhys2dCenter(Int2D pos) {
        return new Vector2f((float)pos.getX() + (float)this.size.getX() / 2.0f, (float)pos.getY() + (float)this.size.getY() / 2.0f);
    }

    public Int2D getPosByPhys2dCenter(ROVector2f v) {
        return new Int2D((int)(v.getX() - (float)this.size.getX() / 2.0f), (int)(v.getY() - (float)this.size.getY() / 2.0f));
    }
}

