/*
 * Decompiled with CFR 0.152.
 */
package kutil.shapes;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import kutil.core.Int2D;
import kutil.core.Log;
import kutil.shapes.EarthShape;
import kutil.shapes.ImageShape;
import kutil.shapes.KShape;
import kutil.shapes.RectangleShape;

public class ShapeFactory {
    public BufferedImage unarImg = this.img("unar.png");
    public BufferedImage unarImgSel = this.img("unar_selected.png");
    public BufferedImage inImg;
    public BufferedImage inImgSel;
    public BufferedImage outImg;
    public BufferedImage outImgSel;
    public BufferedImage binarImg;
    public BufferedImage binarImgSel;
    public BufferedImage unarBinarImg;
    public BufferedImage unarBinarImgSel;
    public BufferedImage unarBlackImg = this.img("unarblack.png");
    public BufferedImage unarBlackImgSel = this.img("unarblack_selected.png");
    public BufferedImage boxImg;
    public BufferedImage boxImgSel;
    public BufferedImage flyImgSel;
    public BufferedImage waspImgSel;
    public BufferedImage nularImg;
    public BufferedImage nularImgSel;
    public BufferedImage cloudImg;
    public BufferedImage platformImg;
    public BufferedImage platformImgSel;
    public BufferedImage recursionImg;
    public BufferedImage recursionImgSel;
    public BufferedImage upImg;
    public BufferedImage downImg;
    public BufferedImage leftImg;
    public BufferedImage rightImg;
    public BufferedImage randomImg;
    public BufferedImage upImgSel;
    public BufferedImage downImgSel;
    public BufferedImage leftImgSel;
    public BufferedImage rightImgSel;
    public BufferedImage randomImgSel;
    public BufferedImage unarNularImg;
    public BufferedImage unarNularImgSel;
    public BufferedImage slotImg;
    public BufferedImage slotImgSel;
    public BufferedImage ingImg;
    public BufferedImage ingImgSel;
    public BufferedImage ternarImg;
    public BufferedImage ternarImgSel;
    public BufferedImage budhaImg;
    public BufferedImage budhaImgSel;
    public BufferedImage appleImg;
    public BufferedImage appleImgSel;
    public BufferedImage earthImg;
    public BufferedImage earthImgSel;
    public BufferedImage mrImgSel;
    public BufferedImage ffImg;
    public BufferedImage ffImgSel;
    public BufferedImage smallFishImg;
    public BufferedImage panacekImgSel;
    public BufferedImage[] flyImgs;
    public BufferedImage[] waspImgs;
    public BufferedImage[] mrImgs;
    public BufferedImage[] panacekImgs;

    public ShapeFactory() {
        this.inImg = this.img("in.png");
        this.inImgSel = this.img("in_selected.png");
        this.outImg = this.img("out.png");
        this.outImgSel = this.img("out_selected.png");
        this.binarImg = this.img("binar.png");
        this.binarImgSel = this.img("binar_selected.png");
        this.unarBinarImg = this.img("unarbinar.png");
        this.unarBinarImgSel = this.img("unarbinar_selected.png");
        this.boxImg = this.img("box.png");
        this.boxImgSel = this.img("box_selected.png");
        this.flyImgSel = this.img("fly_selected.png");
        this.waspImgSel = this.img("wasp_selected.png");
        this.nularImg = this.img("nular.png");
        this.nularImgSel = this.img("nular_selected.png");
        this.cloudImg = this.img("cloud.png");
        this.platformImg = this.img("platform.png");
        this.platformImgSel = this.img("platform_selected.png");
        this.recursionImg = this.img("recursion.png");
        this.recursionImgSel = this.img("recursion_selected.png");
        this.upImg = this.img("smer-up.png");
        this.upImgSel = this.img("smer-up_selected.png");
        this.downImg = this.img("smer-down.png");
        this.downImgSel = this.img("smer-down_selected.png");
        this.leftImg = this.img("smer-left.png");
        this.leftImgSel = this.img("smer-left_selected.png");
        this.rightImg = this.img("smer-right.png");
        this.rightImgSel = this.img("smer-right_selected.png");
        this.randomImg = this.img("smer-rand.png");
        this.randomImgSel = this.img("smer-rand_selected.png");
        this.unarNularImg = this.img("unarnular.png");
        this.unarNularImgSel = this.img("unarnular_selected.png");
        this.slotImg = this.img("slot.png");
        this.slotImgSel = this.img("slot_selected.png");
        this.ingImg = this.img("ing.png");
        this.ingImgSel = this.img("ing_selected.png");
        this.ternarImg = this.img("ternar.png");
        this.ternarImgSel = this.img("ternar_selected.png");
        this.budhaImg = this.img("budha.png");
        this.budhaImgSel = this.img("budha_selected.png");
        this.appleImg = this.img("apple.png");
        this.appleImgSel = this.img("apple_selected.png");
        this.earthImg = this.img("earth.png");
        this.earthImgSel = this.img("earth_selected.png");
        this.mrImgSel = this.img("pan_selected.png");
        this.ffImg = this.img("ff.png");
        this.ffImgSel = this.img("ff_selected.png");
        this.smallFishImg = this.img("smallfish2.png");
        this.panacekImgSel = this.img("panacek0_selected.png");
        this.flyImgs = new BufferedImage[]{this.img("fly1.png"), this.img("fly2.png"), this.img("fly3.png"), this.img("fly4.png"), this.img("fly5.png")};
        this.waspImgs = new BufferedImage[]{this.img("wasp1.png"), this.img("wasp2.png"), this.img("wasp3.png"), this.img("wasp4.png"), this.img("wasp5.png")};
        this.mrImgs = new BufferedImage[]{this.img("pan1.png"), this.img("pan2.png"), this.img("pan3.png"), this.img("pan4.png"), this.img("pan5.png")};
        this.panacekImgs = new BufferedImage[]{this.img("panacek1.png"), this.img("panacek2.png"), this.img("panacek3.png"), this.img("panacek4.png"), this.img("panacek5.png"), this.img("panacek6.png"), this.img("panacek7.png"), this.img("panacek8.png")};
    }

    public KShape newKShape(String shapeCmd) {
        if (shapeCmd == null) {
            return ShapeFactory.defaultShape();
        }
        String[] parts = shapeCmd.split("\\s+");
        String shapeName = parts[0];
        if ("rectangle".equals(shapeName)) {
            if (parts.length == 4) {
                int x = Integer.parseInt(parts[1]);
                int y = Integer.parseInt(parts[2]);
                Color col = Color.PINK;
                try {
                    col = Color.decode(parts[3]);
                }
                catch (NumberFormatException e) {
                    Log.it("Uncorrect color code : " + e.getMessage());
                }
                return new RectangleShape(new Int2D(x, y), col);
            }
            if (parts.length != 3) {
                return ShapeFactory.defaultShape();
            }
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            return new RectangleShape(new Int2D(x, y), Color.black);
        }
        if ("budha".equals(shapeName)) {
            return new ImageShape(this.img("budha.png"), this.img("budha_selected.png"), new Int2D[]{new Int2D(35, 40), new Int2D(55, 40), new Int2D(80, 80), new Int2D(75, 105), new Int2D(25, 105), new Int2D(15, 80)}, new Int2D(50, 75), new Int2D(50, 100));
        }
        if ("smallfish".equals(shapeName)) {
            return new ImageShape(this.smallFishImg, this.smallFishImg, new Int2D[]{new Int2D(0, 0), new Int2D(44, 0), new Int2D(44, 14), new Int2D(0, 14)}, new Int2D(0, 0), new Int2D(0, 0));
        }
        if ("earth".equals(shapeName)) {
            return new EarthShape();
        }
        if ("cloud".equals(shapeName)) {
            return new ImageShape(this.cloudImg, this.cloudImg, new Int2D[]{new Int2D(180, 100), new Int2D(200, 100), new Int2D(200, 130), new Int2D(180, 130)}, new Int2D(190, 115), new Int2D(190, 115));
        }
        if ("platform".equals(shapeName)) {
            return new ImageShape(this.platformImg, this.platformImgSel, new Int2D[]{new Int2D(32, 38), new Int2D(679, 38), new Int2D(366, 150)}, new Int2D(366, 100), new Int2D(366, 100));
        }
        if ("img".equals(shapeName)) {
            if (parts.length != 5) {
                return ShapeFactory.defaultShape();
            }
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            String filename1 = parts[3];
            String filename2 = parts[4];
            return new ImageShape(this.img(filename1), this.img(filename2), new Int2D[]{new Int2D(0, 0), new Int2D(x, 0), new Int2D(x, y), new Int2D(0, y)}, new Int2D(x / 2, y / 2), new Int2D(x / 2, y / 2));
        }
        if ("img2".equals(shapeName)) {
            if (parts.length != 7) {
                return ShapeFactory.defaultShape();
            }
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            String filename1 = parts[3];
            String filename2 = parts[4];
            int sx = Integer.parseInt(parts[5]);
            int sy = Integer.parseInt(parts[6]);
            return new ImageShape(this.img(filename1), this.img(filename2), new Int2D[]{new Int2D(0, 0), new Int2D(x, 0), new Int2D(x, y), new Int2D(0, y)}, new Int2D(sx, sy), new Int2D(sx, sy));
        }
        return ShapeFactory.defaultShape();
    }

    private BufferedImage img(String file) {
        try {
            return ImageIO.read(this.getClass().getResource("/kutil/img/" + file));
        }
        catch (IOException e) {
            Log.it(e);
            return null;
        }
    }

    public static KShape defaultShape() {
        return new RectangleShape(new Int2D(32, 32), Color.black);
    }
}

