/*
 * Decompiled with CFR 0.152.
 */
package kutil.shapes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.kobjects.Function;
import kutil.shapes.ImageShape;

public class TernarShape
extends ImageShape {
    private Function ternar;
    private static final Font font = new Font("SansSerif", 0, 9);

    public TernarShape(Function t) {
        super(Global.shapeFactory().ternarImg, Global.shapeFactory().ternarImgSel, new Int2D[]{new Int2D(0, 0), new Int2D(100, 0), new Int2D(100, 9), new Int2D(68, 50), new Int2D(33, 50), new Int2D(0, 9)}, new Int2D(0, 0), new Int2D(50, 25));
        this.ternar = t;
    }

    public void draw(Graphics2D g, boolean isSelected, String info, Int2D pos, Int2D center, double rot, boolean isRotable) {
        super.draw(g, isSelected, info, pos, center, rot, isRotable);
        Int2D drawPos = center.plus(pos);
        g.setFont(font);
        g.setColor(Color.black);
        g.drawString(this.ternar.getImplementation().title(), drawPos.getX() + 3 + this.ternar.getImplementation().getTitleShift(), drawPos.getY() + 28);
        if (isSelected) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        if (Global.rucksack().getFrom() == this.ternar) {
            g.drawLine(drawPos.getX() + 50, drawPos.getY() + 50, Global.rucksack().getMouseX(), Global.rucksack().getMouseY());
        }
        if (this.ternar.doDrawArrow(0)) {
            Int2D arrowEnd = this.ternar.getTargetArrowEnd(0).plus(center);
            int cilX = arrowEnd.getX();
            int cilY = arrowEnd.getY();
            g.drawLine(drawPos.getX() + 50, drawPos.getY() + 50, cilX, cilY);
        }
    }
}

