/*
 * Decompiled with CFR 0.152.
 */
package kutil.shapes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import kutil.core.Global;
import kutil.core.Int2D;
import kutil.kobjects.Function;
import kutil.shapes.ImageShape;

public class UnarShape
extends ImageShape {
    private Function unar;
    private boolean isBlack;
    private static final Font font = new Font("SansSerif", 0, 9);

    public UnarShape(Function u, boolean isBlack) {
        super(isBlack ? Global.shapeFactory().unarBlackImg : Global.shapeFactory().unarImg, isBlack ? Global.shapeFactory().unarBlackImgSel : Global.shapeFactory().unarImgSel, new Int2D[]{new Int2D(0, 0), new Int2D(34, 0), new Int2D(34, 50), new Int2D(0, 50)}, new Int2D(0, 0), new Int2D(17, 25));
        this.unar = u;
        this.isBlack = isBlack;
    }

    public void draw(Graphics2D g, boolean isSelected, String info, Int2D pos, Int2D center, double rot, boolean isRotable) {
        super.draw(g, isSelected, info, pos, center, rot, isRotable);
        Int2D drawPos = center.plus(pos);
        if (this.isBlack) {
            g.setFont(font);
            g.setColor(Color.white);
            g.drawString(this.unar.id(), drawPos.getX() + 13 - this.unar.id().length() * 2, drawPos.getY() + 28);
        } else {
            g.setFont(font);
            g.setColor(Color.black);
            g.drawString(this.unar.getImplementation().title(), drawPos.getX() + 3 + this.unar.getImplementation().getTitleShift(), drawPos.getY() + 28);
        }
        if (isSelected) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        if (Global.rucksack().getFrom() == this.unar) {
            g.drawLine(drawPos.getX() + 16, drawPos.getY() + 50, Global.rucksack().getMouseX(), Global.rucksack().getMouseY());
        }
        if (this.unar.doDrawArrow(0)) {
            Int2D arrowEnd = this.unar.getTargetArrowEnd(0).plus(center);
            int cilX = arrowEnd.getX();
            int cilY = arrowEnd.getY();
            g.drawLine(drawPos.getX() + 16, drawPos.getY() + 50, cilX, cilY);
        }
    }
}

