/*
 * Decompiled with CFR 0.152.
 */
package kutil.xml;

import java.util.LinkedList;
import kutil.core.Int2D;
import kutil.kobjects.KObject;
import kutil.xml.Xml;
import kutil.xml.XmlText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElement
implements Xml {
    private String tag;
    private LinkedList<Xml> inside;
    private LinkedList<StringString> atts;

    public XmlElement(String tag) {
        this.tag = tag;
        this.inside = new LinkedList();
        this.atts = new LinkedList();
    }

    public void add(Xml xml) {
        this.inside.add(xml);
    }

    public void addAtt(String att, String val) {
        if (val == null) {
            return;
        }
        this.atts.add(new StringString(att, val));
    }

    public void addAtt(String att, Integer val) {
        if (val == null) {
            return;
        }
        this.atts.add(new StringString(att, val.toString()));
    }

    public void addAtt(String att, Boolean val) {
        if (val == null) {
            return;
        }
        this.atts.add(new StringString(att, val.toString()));
    }

    public void addAtt(String att, Int2D val) {
        if (val == null) {
            return;
        }
        this.atts.add(new StringString(att, val.toString()));
    }

    public void addAtt(String att, Double val) {
        if (val == null) {
            return;
        }
        this.atts.add(new StringString(att, val.toString()));
    }

    public void changeType(String type) {
        for (StringString ss : this.atts) {
            if (!"type".equals(ss.s1)) continue;
            ss.s2 = type;
            return;
        }
        for (Xml x : this.inside) {
            if (!(x instanceof XmlElement)) continue;
            XmlElement elem = (XmlElement)x;
            if (!elem.tag.equals("type")) continue;
            elem.inside.clear();
            elem.inside.add(new XmlText(type));
            return;
        }
        this.atts.add(new StringString("type", type));
    }

    public void addText(String tag, String text) {
        if (text == null) {
            return;
        }
        XmlElement elem = new XmlElement(tag);
        elem.add(new XmlText(text));
        this.inside.add(elem);
    }

    public void addText(String tag, Integer i) {
        if (i == null) {
            return;
        }
        XmlElement elem = new XmlElement(tag);
        elem.add(new XmlText(i.toString()));
        this.inside.add(elem);
    }

    public void addKObjectList(String tag, LinkedList<KObject> list) {
        if (list == null) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        XmlElement el = new XmlElement(tag);
        for (KObject o : list) {
            el.add(o.toXml());
        }
        this.inside.add(el);
    }

    private String ods(int ods) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < ods; ++i) {
            ret.append("    ");
        }
        return ret.toString();
    }

    private String toStringOdsad(int ods, boolean vypisTag) {
        StringBuilder sb = new StringBuilder();
        if (vypisTag) {
            sb.append(this.ods(ods)).append("<").append(this.tag);
            for (StringString ss : this.atts) {
                sb.append(" ").append(ss.toString());
            }
        }
        if (!this.inside.isEmpty()) {
            if (vypisTag) {
                sb.append(">\n");
            }
            for (Xml xml : this.inside) {
                if (xml instanceof XmlText) {
                    sb.append(this.ods(ods + 1)).append(xml.toString());
                    continue;
                }
                XmlElement elem = (XmlElement)xml;
                if (elem.tag.equals("inside")) {
                    sb.append(elem.toStringOdsad(ods, false));
                    continue;
                }
                sb.append(elem.toStringOdsad(ods + 1, true));
            }
            if (vypisTag) {
                sb.append(this.ods(ods)).append("</").append(this.tag).append(">");
            }
        } else if (vypisTag) {
            sb.append("/>");
        }
        if (vypisTag) {
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toStringOdsad(0, true);
    }

    private class StringString {
        public String s1;
        public String s2;

        public StringString(String att, String val) {
            this.s1 = att;
            this.s2 = val;
        }

        public String toString() {
            return this.s1 + "=\"" + this.s2 + "\"";
        }
    }
}

