/*
 * Decompiled with CFR 0.152.
 */
package kutil.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Stack;
import kutil.core.Global;
import kutil.core.IdDB;
import kutil.core.KAtts;
import kutil.core.Log;
import kutil.kobjects.KObject;
import kutil.kobjects.KObjectFactory;
import kutil.kobjects.Text;
import kutil.kobjects.Time;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlLoader
implements ContentHandler {
    private static final boolean loguj = false;
    private Locator locator;
    private StringBuilder textBuffer;
    private StringBuilder odsazeni;
    private Stav stav;
    private Stack<Stav> minuleStavy;
    private Stack<String> aktualniTag;
    private Stack<KAtts> kAttsStack;
    private LinkedList<Time> times;
    private IdDB idDB;

    private void init() {
        this.stav = Stav.init;
        this.idDB = Global.idDB();
        this.minuleStavy = new Stack();
        this.aktualniTag = new Stack();
        this.kAttsStack = new Stack();
        this.kAttsStack.add(new KAtts());
        this.textBuffer = new StringBuilder();
        this.odsazeni = new StringBuilder();
        this.times = new LinkedList();
    }

    public KAtts loadResource(String filename) {
        try {
            filename = "/kutil/xml/" + filename;
            InputStream inputStream = this.getClass().getResource(filename).openStream();
            InputSource source = new InputSource(inputStream);
            return this.loadFromInputSource(source);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public KAtts loadFile(String filename) {
        try {
            InputSource source = new InputSource(filename);
            return this.loadFromInputSource(source);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public KAtts loadString(String str) {
        try {
            InputSource source = new InputSource(new StringReader(str));
            return this.loadFromInputSource(source);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void error(String msg) throws XmlLoaderException {
        Log.it("[" + this.locator.getLineNumber() + "] XML-ERROR: " + msg);
        throw new XmlLoaderException(msg);
    }

    private KAtts loadFromInputSource(InputSource source) {
        this.init();
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(this);
            parser.parse(source);
            KAtts ret = this.kAttsStack.peek();
            ret.parentInfo();
            ret.init();
            for (Time t : this.times) {
                ret.add("times", t);
            }
            return ret;
        }
        catch (XmlLoaderException e) {
            return null;
        }
        catch (SAXException e) {
            Log.it("[" + this.locator.getLineNumber() + "] XML-ERROR: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.textBuffer.append(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.stav == Stav.init && !"kutil".equals(localName)) {
            this.error("Ko\u0159enov\u00fd element mus\u00ed b\u00fdt <kutil>.");
        }
        this.minuleStavy.push(this.stav);
        if ("object".equals(localName)) {
            if (this.stav == Stav.insideTag) {
                this.stav = Stav.insideObject;
                this.kAttsStack.push(new KAtts());
            } else if (this.stav == Stav.insideObject || this.stav == Stav.insideInnerObject) {
                this.stav = Stav.insideInnerObject;
                this.kAttsStack.push(new KAtts());
            }
            KAtts kAtts = this.kAttsStack.peek();
            for (int i = 0; i < atts.getLength(); ++i) {
                kAtts.add(atts.getLocalName(i), new Text(atts.getValue(i)));
            }
        } else {
            if (this.stav == Stav.insideTag) {
                this.error("Na m\u00edsto <" + localName + "> by m\u011bl b\u00fdt element <object> nebo text.");
            }
            this.stav = Stav.insideTag;
            this.aktualniTag.push(localName);
        }
        this.odsazeni.append(" ");
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.stav == Stav.insideTag) {
            if (this.textBuffer.length() != 0) {
                String str = this.textBuffer.toString().replaceAll("\\s+", " ").trim();
                this.textBuffer.setLength(0);
                if (!"".equals(str)) {
                    Text text = new Text(str);
                    this.kAttsStack.peek().add(this.aktualniTag.peek(), text);
                }
            }
            this.aktualniTag.pop();
        } else if (this.stav == Stav.insideObject || this.stav == Stav.insideInnerObject) {
            KAtts kAttsProNovyObject = this.kAttsStack.pop();
            KObject newKObject = KObjectFactory.newKObject(kAttsProNovyObject);
            String id = kAttsProNovyObject.getString("id");
            if (id != null) {
                this.idDB.put(id, newKObject);
            }
            String tag = this.stav == Stav.insideObject ? this.aktualniTag.peek() : "inside";
            this.kAttsStack.peek().add(tag, newKObject);
            if (newKObject instanceof Time) {
                this.times.add((Time)newKObject);
            }
        }
        this.stav = this.minuleStavy.pop();
        this.odsazeni.deleteCharAt(0);
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private class XmlLoaderException
    extends SAXException {
        public XmlLoaderException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stav {
        init,
        insideObject,
        insideTag,
        insideInnerObject;

    }
}

