/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import net.phys2d.math.Vector2f;
import net.phys2d.raw.BasicJoint;
import net.phys2d.raw.Body;
import net.phys2d.raw.Joint;

public class ConstrainingJoint
implements Joint {
    private BasicJoint realJoint;
    private float distance;
    private Body body1;
    private Body body2;
    private boolean active;

    public ConstrainingJoint(Body body1, Body body2, Vector2f anchor, float distance) {
        this.distance = distance;
        this.body1 = body1;
        this.body2 = body2;
        this.realJoint = new BasicJoint(body1, body2, anchor);
    }

    public boolean isActive() {
        if (this.body1.getPosition().distanceSquared(this.body2.getPosition()) < this.distance) {
            Vector2f to2 = new Vector2f(this.body2.getPosition());
            to2.sub(this.body1.getPosition());
            to2.normalise();
            Vector2f vel = new Vector2f(this.body1.getVelocity());
            vel.normalise();
            if (this.body1.getVelocity().dot(to2) < 0.0f) {
                return true;
            }
        }
        return false;
    }

    public void applyImpulse() {
        if (this.active) {
            this.realJoint.applyImpulse();
        }
    }

    public Body getBody1() {
        return this.body1;
    }

    public Body getBody2() {
        return this.body2;
    }

    public void preStep(float invDT) {
        if (this.isActive()) {
            this.active = true;
            this.realJoint.preStep(invDT);
        } else {
            this.active = false;
        }
    }

    public void setRelaxation(float relaxation) {
    }
}

