/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Matrix2f;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Joint;

public strictfp class ElasticJoint
implements Joint {
    public static int NEXT_ID = 0;
    private Body body1;
    private Body body2;
    private Matrix2f M = new Matrix2f();
    private Vector2f localAnchor1 = new Vector2f();
    private Vector2f localAnchor2 = new Vector2f();
    private Vector2f r1 = new Vector2f();
    private Vector2f r2 = new Vector2f();
    private Vector2f bias = new Vector2f();
    private Vector2f accumulatedImpulse = new Vector2f();
    private float relaxation;
    private int id = NEXT_ID++;

    public ElasticJoint(Body b1, Body b2) {
        this.accumulatedImpulse.set(0.0f, 0.0f);
        this.relaxation = 1.0f;
        this.set(b1, b2);
    }

    public void setRelaxation(float relaxation) {
        this.relaxation = relaxation;
    }

    public ROVector2f getLocalAnchor1() {
        return this.localAnchor1;
    }

    public ROVector2f getLocalAnchor2() {
        return this.localAnchor2;
    }

    public Body getBody1() {
        return this.body1;
    }

    public Body getBody2() {
        return this.body2;
    }

    public void set(Body b1, Body b2) {
        this.body1 = b1;
        this.body2 = b2;
        Matrix2f rot1 = new Matrix2f(this.body1.getRotation());
        Matrix2f rot2 = new Matrix2f(this.body2.getRotation());
        Matrix2f rot1T = rot1.transpose();
        Matrix2f rot2T = rot2.transpose();
        Vector2f a1 = new Vector2f(this.body2.getPosition());
        a1.sub(this.body1.getPosition());
        this.localAnchor1 = MathUtil.mul(rot1T, a1);
        Vector2f a2 = new Vector2f(this.body1.getPosition());
        a2.sub(this.body2.getPosition());
        this.localAnchor2 = MathUtil.mul(rot2T, a2);
        this.accumulatedImpulse.set(0.0f, 0.0f);
        this.relaxation = 1.0f;
    }

    public void preStep(float invDT) {
        Matrix2f rot1 = new Matrix2f(this.body1.getRotation());
        Matrix2f rot2 = new Matrix2f(this.body2.getRotation());
        this.r1 = MathUtil.mul(rot1, this.localAnchor1);
        this.r2 = MathUtil.mul(rot2, this.localAnchor2);
        Matrix2f K1 = new Matrix2f();
        K1.col1.x = this.body1.getInvMass() + this.body2.getInvMass();
        K1.col2.x = 0.0f;
        K1.col1.y = 0.0f;
        K1.col2.y = this.body1.getInvMass() + this.body2.getInvMass();
        Matrix2f K2 = new Matrix2f();
        K2.col1.x = this.body1.getInvI() * this.r1.y * this.r1.y;
        K2.col2.x = -this.body1.getInvI() * this.r1.x * this.r1.y;
        K2.col1.y = -this.body1.getInvI() * this.r1.x * this.r1.y;
        K2.col2.y = this.body1.getInvI() * this.r1.x * this.r1.x;
        Matrix2f K3 = new Matrix2f();
        K3.col1.x = this.body2.getInvI() * this.r2.y * this.r2.y;
        K3.col2.x = -this.body2.getInvI() * this.r2.x * this.r2.y;
        K3.col1.y = -this.body2.getInvI() * this.r2.x * this.r2.y;
        K3.col2.y = this.body2.getInvI() * this.r2.x * this.r2.x;
        Matrix2f K = MathUtil.add(MathUtil.add(K1, K2), K3);
        this.M = K.invert();
        Vector2f p1 = new Vector2f(this.body1.getPosition());
        p1.add(this.r1);
        Vector2f p2 = new Vector2f(this.body2.getPosition());
        p2.add(this.r2);
        Vector2f dp = new Vector2f(p2);
        dp.sub(p1);
        this.bias = new Vector2f(dp);
        this.bias.scale(-0.1f);
        this.bias.scale(invDT);
        this.accumulatedImpulse.scale(this.relaxation);
        Vector2f accum1 = new Vector2f(this.accumulatedImpulse);
        accum1.scale(-this.body1.getInvMass());
        this.body1.adjustVelocity(accum1);
        this.body1.adjustAngularVelocity(-(this.body1.getInvI() * MathUtil.cross(this.r1, this.accumulatedImpulse)));
        Vector2f accum2 = new Vector2f(this.accumulatedImpulse);
        accum2.scale(this.body2.getInvMass());
        this.body2.adjustVelocity(accum2);
        this.body2.adjustAngularVelocity(this.body2.getInvI() * MathUtil.cross(this.r2, this.accumulatedImpulse));
    }

    public void applyImpulse() {
        Vector2f dv = new Vector2f(this.body2.getVelocity());
        dv.add(MathUtil.cross(this.body2.getAngularVelocity(), this.r2));
        dv.sub(this.body1.getVelocity());
        dv.sub(MathUtil.cross(this.body1.getAngularVelocity(), this.r1));
        dv.scale(-1.0f);
        dv.add(this.bias);
        if (dv.lengthSquared() == 0.0f) {
            return;
        }
        Vector2f impulse = MathUtil.mul(this.M, dv);
        Vector2f delta1 = new Vector2f(impulse);
        delta1.scale(-this.body1.getInvMass());
        this.body1.adjustVelocity(delta1);
        this.body1.adjustAngularVelocity(-this.body1.getInvI() * MathUtil.cross(this.r1, impulse));
        Vector2f delta2 = new Vector2f(impulse);
        delta2.scale(this.body2.getInvMass());
        this.body2.adjustVelocity(delta2);
        this.body2.adjustAngularVelocity(this.body2.getInvI() * MathUtil.cross(this.r2, impulse));
        this.accumulatedImpulse.add(impulse);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other.getClass() == this.getClass()) {
            return ((ElasticJoint)other).id == this.id;
        }
        return false;
    }
}

