/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Matrix2f;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Joint;

public strictfp class SpringJoint
implements Joint {
    public static int NEXT_ID = 0;
    private Body body1;
    private Body body2;
    private Vector2f localAnchor1 = new Vector2f();
    private Vector2f localAnchor2 = new Vector2f();
    private float stretchedSpringConst = 100.0f;
    private float compressedSpringConst = 100.0f;
    private float brokenSpringConst = 100.0f;
    private float springSize;
    private float maxSpringSize;
    private float minSpringSize;
    private int id;
    private float springLength;
    private Vector2f spring;
    private float massNormal;
    private Vector2f r1 = new Vector2f();
    private Vector2f r2 = new Vector2f();
    private boolean isBroken;

    public SpringJoint(Body b1, Body b2, ROVector2f anchor1, ROVector2f anchor2) {
        this.id = NEXT_ID++;
        Vector2f spring = new Vector2f(anchor1);
        spring.sub(anchor2);
        this.springSize = spring.length();
        this.minSpringSize = 0.0f;
        this.maxSpringSize = 2.0f * this.springSize;
        this.set(b1, b2, anchor1, anchor2);
    }

    public ROVector2f getLocalAnchor1() {
        return this.localAnchor1;
    }

    public ROVector2f getLocalAnchor2() {
        return this.localAnchor2;
    }

    public Body getBody1() {
        return this.body1;
    }

    public Body getBody2() {
        return this.body2;
    }

    public void set(Body b1, Body b2, ROVector2f anchor1, ROVector2f anchor2) {
        this.body1 = b1;
        this.body2 = b2;
        Matrix2f rot1 = new Matrix2f(this.body1.getRotation());
        Matrix2f rot1T = rot1.transpose();
        Vector2f a1 = new Vector2f(anchor1);
        a1.sub(this.body1.getPosition());
        this.localAnchor1 = MathUtil.mul(rot1T, a1);
        Matrix2f rot2 = new Matrix2f(this.body2.getRotation());
        Matrix2f rot2T = rot2.transpose();
        Vector2f a2 = new Vector2f(anchor2);
        a2.sub(this.body2.getPosition());
        this.localAnchor2 = MathUtil.mul(rot2T, a2);
    }

    public void preStep(float invDT) {
        float springConst;
        this.spring = new Vector2f(this.body2.getPosition());
        this.spring.add(this.r2);
        this.spring.sub(this.body1.getPosition());
        this.spring.sub(this.r1);
        this.springLength = this.spring.length();
        this.spring.normalise();
        if (this.springLength < this.minSpringSize || this.springLength > this.maxSpringSize) {
            Matrix2f rot1 = new Matrix2f(this.body1.getRotation());
            Matrix2f rot2 = new Matrix2f(this.body2.getRotation());
            this.r1 = MathUtil.mul(rot1, this.localAnchor1);
            this.r2 = MathUtil.mul(rot2, this.localAnchor2);
            float rn1 = this.r1.dot(this.spring);
            float rn2 = this.r2.dot(this.spring);
            float kNormal = this.body1.getInvMass() + this.body2.getInvMass();
            this.massNormal = 1.0f / (kNormal += this.body1.getInvI() * (this.r1.dot(this.r1) - rn1 * rn1) + this.body2.getInvI() * (this.r2.dot(this.r2) - rn2 * rn2));
            float springImpulse = invDT != 0.0f ? this.brokenSpringConst * (this.springLength - this.springSize) / invDT : 0.0f;
            Vector2f impulse = MathUtil.scale(this.spring, springImpulse);
            this.body1.adjustBiasedVelocity(MathUtil.scale(impulse, this.body1.getInvMass()));
            this.body1.adjustBiasedAngularVelocity(this.body1.getInvI() * MathUtil.cross(this.r1, impulse));
            this.body2.adjustBiasedVelocity(MathUtil.scale(impulse, -this.body2.getInvMass()));
            this.body2.adjustBiasedAngularVelocity(-(this.body2.getInvI() * MathUtil.cross(this.r2, impulse)));
            this.isBroken = true;
            return;
        }
        if (this.springLength < this.springSize) {
            springConst = this.compressedSpringConst;
            this.isBroken = false;
        } else {
            springConst = this.stretchedSpringConst;
            this.isBroken = false;
        }
        float springImpulse = invDT != 0.0f ? springConst * (this.springLength - this.springSize) / invDT : 0.0f;
        Vector2f impulse = MathUtil.scale(this.spring, springImpulse);
        this.body1.adjustVelocity(MathUtil.scale(impulse, this.body1.getInvMass()));
        this.body1.adjustAngularVelocity(this.body1.getInvI() * MathUtil.cross(this.r1, impulse));
        this.body2.adjustVelocity(MathUtil.scale(impulse, -this.body2.getInvMass()));
        this.body2.adjustAngularVelocity(-(this.body2.getInvI() * MathUtil.cross(this.r2, impulse)));
    }

    public void applyImpulse() {
        if (this.isBroken) {
            Vector2f relativeVelocity = new Vector2f(this.body2.getVelocity());
            relativeVelocity.add(MathUtil.cross(this.body2.getAngularVelocity(), this.r2));
            relativeVelocity.sub(this.body1.getVelocity());
            relativeVelocity.sub(MathUtil.cross(this.body1.getAngularVelocity(), this.r1));
            float normalImpulse = this.massNormal * relativeVelocity.dot(this.spring);
            if (this.springLength < this.minSpringSize && normalImpulse < 0.0f || this.springLength > this.maxSpringSize && normalImpulse > 0.0f) {
                Vector2f impulse = MathUtil.scale(this.spring, normalImpulse);
                this.body1.adjustVelocity(MathUtil.scale(impulse, this.body1.getInvMass()));
                this.body1.adjustAngularVelocity(this.body1.getInvI() * MathUtil.cross(this.r1, impulse));
                this.body2.adjustVelocity(MathUtil.scale(impulse, -this.body2.getInvMass()));
                this.body2.adjustAngularVelocity(-(this.body2.getInvI() * MathUtil.cross(this.r2, impulse)));
            }
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other.getClass() == this.getClass()) {
            return ((SpringJoint)other).id == this.id;
        }
        return false;
    }

    public void setRelaxation(float relaxation) {
    }

    public float getBrokenSpringConst() {
        return this.brokenSpringConst;
    }

    public void setBrokenSpringConst(float brokenSpringConst) {
        this.brokenSpringConst = brokenSpringConst;
    }

    public float getCompressedSpringConst() {
        return this.compressedSpringConst;
    }

    public void setCompressedSpringConst(float compressedSpringConst) {
        this.compressedSpringConst = compressedSpringConst;
    }

    public float getMaxSpringSize() {
        return this.maxSpringSize;
    }

    public void setMaxSpringSize(float maxSpringSize) {
        this.maxSpringSize = maxSpringSize;
        this.springSize = this.springSize > maxSpringSize ? maxSpringSize : this.springSize;
    }

    public float getMinSpringSize() {
        return this.minSpringSize;
    }

    public void setMinSpringSize(float minSpringSize) {
        this.minSpringSize = minSpringSize;
        this.springSize = this.springSize < minSpringSize ? minSpringSize : this.springSize;
    }

    public float getSpringSize() {
        return this.springSize;
    }

    public void setSpringSize(float springSize) {
        this.springSize = springSize;
        this.maxSpringSize = springSize > this.maxSpringSize ? springSize : this.maxSpringSize;
        this.minSpringSize = springSize < this.minSpringSize ? springSize : this.minSpringSize;
    }

    public float getStretchedSpringConst() {
        return this.stretchedSpringConst;
    }

    public void setStretchedSpringConst(float stretchedSpringConst) {
        this.stretchedSpringConst = stretchedSpringConst;
    }
}

